/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.SortValue;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.schema.IndexCastMapping;
import org.apache.paimon.schema.SchemaEvolutionUtil;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Pair;

public class FormatReaderMapping {
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castMapping;
    @Nullable
    private final Pair<int[], RowType> partitionPair;
    private final FormatReaderFactory readerFactory;
    private final TableSchema dataSchema;
    private final List<Predicate> dataFilters;
    private final Map<String, Integer> systemFields;
    @Nullable
    private final TopN topN;
    @Nullable
    private final Integer limit;

    public FormatReaderMapping(@Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping, @Nullable int[] trimmedKeyMapping, @Nullable Pair<int[], RowType> partitionPair, FormatReaderFactory readerFactory, TableSchema dataSchema, List<Predicate> dataFilters, Map<String, Integer> systemFields, @Nullable TopN topN, @Nullable Integer limit) {
        this.indexMapping = this.combine(indexMapping, trimmedKeyMapping);
        this.castMapping = castMapping;
        this.readerFactory = readerFactory;
        this.partitionPair = partitionPair;
        this.dataSchema = dataSchema;
        this.dataFilters = dataFilters;
        this.systemFields = systemFields;
        this.topN = topN;
        this.limit = limit;
    }

    private int[] combine(@Nullable int[] indexMapping, @Nullable int[] trimmedKeyMapping) {
        if (indexMapping == null) {
            return trimmedKeyMapping;
        }
        if (trimmedKeyMapping == null) {
            return indexMapping;
        }
        int[] combined = new int[indexMapping.length];
        for (int i = 0; i < indexMapping.length; ++i) {
            combined[i] = indexMapping[i] < 0 ? indexMapping[i] : trimmedKeyMapping[indexMapping[i]];
        }
        return combined;
    }

    @Nullable
    public int[] getIndexMapping() {
        return this.indexMapping;
    }

    @Nullable
    public CastFieldGetter[] getCastMapping() {
        return this.castMapping;
    }

    @Nullable
    public Pair<int[], RowType> getPartitionPair() {
        return this.partitionPair;
    }

    public Map<String, Integer> getSystemFields() {
        return this.systemFields;
    }

    public FormatReaderFactory getReaderFactory() {
        return this.readerFactory;
    }

    public TableSchema getDataSchema() {
        return this.dataSchema;
    }

    public List<Predicate> getDataFilters() {
        return this.dataFilters;
    }

    @Nullable
    public TopN getTopN() {
        return this.topN;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder {
        private final FileFormatDiscover formatDiscover;
        private final List<DataField> readFields;
        private final Function<TableSchema, List<DataField>> fieldsExtractor;
        @Nullable
        private final List<Predicate> filters;
        @Nullable
        private final TopN topN;
        @Nullable
        private final Integer limit;

        public Builder(FileFormatDiscover formatDiscover, List<DataField> readFields, Function<TableSchema, List<DataField>> fieldsExtractor, @Nullable List<Predicate> filters, @Nullable TopN topN, @Nullable Integer limit) {
            this.formatDiscover = formatDiscover;
            this.readFields = readFields;
            this.fieldsExtractor = fieldsExtractor;
            this.filters = filters;
            this.topN = topN;
            this.limit = limit;
        }

        public FormatReaderMapping build(String formatIdentifier, TableSchema tableSchema, TableSchema dataSchema, List<DataField> expectedFields, boolean enabledFilterPushDown) {
            ArrayList<DataField> allDataFieldsInFile = new ArrayList<DataField>((Collection)this.fieldsExtractor.apply(dataSchema));
            Map<String, Integer> systemFields = this.findSystemFields(expectedFields);
            List<DataField> readDataFields = this.readDataFields(allDataFieldsInFile, expectedFields);
            IndexCastMapping indexCastMapping = SchemaEvolutionUtil.createIndexCastMapping(expectedFields, readDataFields);
            Pair<int[], RowType> trimmedKeyPair = Builder.trimKeyFields(readDataFields, allDataFieldsInFile);
            Pair<Pair<int[], RowType>, List<DataField>> trimmedResult = PartitionUtils.trimPartitionFields(dataSchema, trimmedKeyPair.getRight().getFields());
            Pair<int[], RowType> partitionMapping = trimmedResult.getLeft();
            RowType actualReadRowType = new RowType(trimmedResult.getRight());
            List<Predicate> readFilters = enabledFilterPushDown ? this.readFilters(this.filters, tableSchema, dataSchema) : null;
            return new FormatReaderMapping(indexCastMapping.getIndexMapping(), indexCastMapping.getCastMapping(), trimmedKeyPair.getLeft(), partitionMapping, this.formatDiscover.discover(formatIdentifier).createReaderFactory(new RowType(allDataFieldsInFile), actualReadRowType, readFilters), dataSchema, readFilters, systemFields, this.evolutionTopN(tableSchema, dataSchema), this.limit);
        }

        @Nullable
        private TopN evolutionTopN(TableSchema tableSchema, TableSchema dataSchema) {
            TopN pushTopN = this.topN;
            if (pushTopN != null) {
                Map<String, DataField> tableFields = tableSchema.nameToFieldMap();
                Map<Integer, DataField> dataFields = dataSchema.idToFieldMap();
                for (SortValue value : pushTopN.orders()) {
                    DataField dataField;
                    DataField tableField = tableFields.get(value.field().name());
                    if (Objects.equals(tableField, dataField = dataFields.get(tableField.id()))) continue;
                    pushTopN = null;
                    break;
                }
            }
            return pushTopN;
        }

        public FormatReaderMapping build(String formatIdentifier, TableSchema tableSchema, TableSchema dataSchema) {
            return this.build(formatIdentifier, tableSchema, dataSchema, this.readFields, true);
        }

        private Map<String, Integer> findSystemFields(List<DataField> readTableFields) {
            HashMap<String, Integer> systemFields = new HashMap<String, Integer>();
            for (int i = 0; i < readTableFields.size(); ++i) {
                DataField field = readTableFields.get(i);
                if (!SpecialFields.isSystemField(field.name())) continue;
                systemFields.put(field.name(), i);
            }
            return systemFields;
        }

        static Pair<int[], RowType> trimKeyFields(List<DataField> fieldsWithoutPartition, List<DataField> fields) {
            int[] map = new int[fieldsWithoutPartition.size()];
            ArrayList<DataField> trimmedFields = new ArrayList<DataField>();
            HashMap<Integer, DataField> fieldMap = new HashMap<Integer, DataField>();
            HashMap<Integer, Integer> positionMap = new HashMap<Integer, Integer>();
            for (DataField field : fields) {
                fieldMap.put(field.id(), field);
            }
            for (int i = 0; i < fieldsWithoutPartition.size(); ++i) {
                DataField field;
                field = fieldsWithoutPartition.get(i);
                boolean keyField = SpecialFields.isKeyField(field.name());
                int id = keyField ? field.id() - 0x3FFFFFFF : field.id();
                DataField f = (DataField)fieldMap.get(id);
                if (f != null) {
                    if (positionMap.containsKey(id)) {
                        map[i] = (Integer)positionMap.get(id);
                        continue;
                    }
                    map[i] = positionMap.computeIfAbsent(id, k -> trimmedFields.size());
                    trimmedFields.add(keyField ? f : field);
                    continue;
                }
                throw new RuntimeException("Can't find field with id: " + id + " in fields.");
            }
            return Pair.of(map, new RowType(trimmedFields));
        }

        private List<DataField> readDataFields(List<DataField> allDataFields, List<DataField> expectedFields) {
            ArrayList<DataField> readDataFields = new ArrayList<DataField>();
            for (DataField dataField : allDataFields) {
                expectedFields.stream().filter(f -> f.id() == dataField.id()).findFirst().ifPresent(field -> {
                    DataType prunedType = this.pruneDataType(field.type(), dataField.type());
                    if (prunedType != null) {
                        readDataFields.add(dataField.newType(prunedType));
                    }
                });
            }
            return readDataFields;
        }

        @Nullable
        private DataType pruneDataType(DataType readType, DataType dataType) {
            switch (readType.getTypeRoot()) {
                case ROW: {
                    RowType r = (RowType)readType;
                    RowType d = (RowType)dataType;
                    ArrayList<DataField> newFields = new ArrayList<DataField>();
                    for (DataField rf : r.getFields()) {
                        if (!d.containsField(rf.id())) continue;
                        DataField df = d.getField(rf.id());
                        DataType newType = this.pruneDataType(rf.type(), df.type());
                        if (newType == null) continue;
                        newFields.add(df.newType(newType));
                    }
                    if (newFields.isEmpty()) {
                        return null;
                    }
                    return d.copy(newFields);
                }
                case MAP: {
                    DataType keyType = this.pruneDataType(((MapType)readType).getKeyType(), ((MapType)dataType).getKeyType());
                    DataType valueType = this.pruneDataType(((MapType)readType).getValueType(), ((MapType)dataType).getValueType());
                    if (keyType == null || valueType == null) {
                        return null;
                    }
                    return ((MapType)dataType).newKeyValueType(keyType, valueType);
                }
                case ARRAY: {
                    DataType elementType = this.pruneDataType(((ArrayType)readType).getElementType(), ((ArrayType)dataType).getElementType());
                    if (elementType == null) {
                        return null;
                    }
                    return ((ArrayType)dataType).newElementType(elementType);
                }
            }
            return dataType;
        }

        private List<Predicate> readFilters(List<Predicate> filters, TableSchema tableSchema, TableSchema fileSchema) {
            List<Predicate> dataFilters = tableSchema.id() == fileSchema.id() ? filters : SchemaEvolutionUtil.devolveFilters(tableSchema.fields(), fileSchema.fields(), filters, false);
            return PredicateBuilder.excludePredicateWithFields(dataFilters, new HashSet<String>(fileSchema.partitionKeys()));
        }
    }
}

