/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.ExternalPathProvider;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexInDataFileDirPathFactory;
import org.apache.paimon.index.IndexPathFactory;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.Preconditions;

@ThreadSafe
public class FileStorePathFactory {
    public static final String MANIFEST_PATH = "manifest";
    public static final String MANIFEST_PREFIX = "manifest-";
    public static final String MANIFEST_LIST_PREFIX = "manifest-list-";
    public static final String INDEX_MANIFEST_PREFIX = "index-manifest-";
    public static final String INDEX_PATH = "index";
    public static final String INDEX_PREFIX = "index-";
    public static final String STATISTICS_PATH = "statistics";
    public static final String STATISTICS_PREFIX = "stat-";
    public static final String BUCKET_PATH_PREFIX = "bucket-";
    private final Path root;
    private final String uuid;
    private final InternalRowPartitionComputer partitionComputer;
    private final String formatIdentifier;
    private final String dataFilePrefix;
    private final String changelogFilePrefix;
    private final boolean fileSuffixIncludeCompression;
    private final String fileCompression;
    @Nullable
    private final String dataFilePathDirectory;
    private final boolean indexFileInDataFileDir;
    private final AtomicInteger manifestFileCount;
    private final AtomicInteger manifestListCount;
    private final AtomicInteger indexManifestCount;
    private final AtomicInteger indexFileCount;
    private final AtomicInteger statsFileCount;
    private final List<Path> externalPaths;

    public FileStorePathFactory(Path root, RowType partitionType, String defaultPartValue, String formatIdentifier, String dataFilePrefix, String changelogFilePrefix, boolean legacyPartitionName, boolean fileSuffixIncludeCompression, String fileCompression, @Nullable String dataFilePathDirectory, List<Path> externalPaths, boolean indexFileInDataFileDir) {
        this.root = root;
        this.dataFilePathDirectory = dataFilePathDirectory;
        this.indexFileInDataFileDir = indexFileInDataFileDir;
        this.uuid = UUID.randomUUID().toString();
        this.partitionComputer = FileStorePathFactory.getPartitionComputer(partitionType, defaultPartValue, legacyPartitionName);
        this.formatIdentifier = formatIdentifier;
        this.dataFilePrefix = dataFilePrefix;
        this.changelogFilePrefix = changelogFilePrefix;
        this.fileSuffixIncludeCompression = fileSuffixIncludeCompression;
        this.fileCompression = fileCompression;
        this.manifestFileCount = new AtomicInteger(0);
        this.manifestListCount = new AtomicInteger(0);
        this.indexManifestCount = new AtomicInteger(0);
        this.indexFileCount = new AtomicInteger(0);
        this.statsFileCount = new AtomicInteger(0);
        this.externalPaths = externalPaths;
    }

    public Path root() {
        return this.root;
    }

    public Path manifestPath() {
        return new Path(this.root, MANIFEST_PATH);
    }

    public Path indexPath() {
        return new Path(this.root, INDEX_PATH);
    }

    public Path statisticsPath() {
        return new Path(this.root, STATISTICS_PATH);
    }

    public Path dataFilePath() {
        if (this.dataFilePathDirectory != null) {
            return new Path(this.root, this.dataFilePathDirectory);
        }
        return this.root;
    }

    @VisibleForTesting
    public static InternalRowPartitionComputer getPartitionComputer(RowType partitionType, String defaultPartValue, boolean legacyPartitionName) {
        String[] partitionColumns = partitionType.getFieldNames().toArray(new String[0]);
        return new InternalRowPartitionComputer(defaultPartValue, partitionType, partitionColumns, legacyPartitionName);
    }

    public Path newManifestFile() {
        return this.toManifestFilePath(MANIFEST_PREFIX + this.uuid + "-" + this.manifestFileCount.getAndIncrement());
    }

    public Path newManifestList() {
        return this.toManifestListPath(MANIFEST_LIST_PREFIX + this.uuid + "-" + this.manifestListCount.getAndIncrement());
    }

    public Path toManifestFilePath(String manifestFileName) {
        return new Path(this.manifestPath(), manifestFileName);
    }

    public Path toManifestListPath(String manifestListName) {
        return new Path(this.manifestPath(), manifestListName);
    }

    public DataFilePathFactory createDataFilePathFactory(BinaryRow partition, int bucket) {
        return new DataFilePathFactory(this.bucketPath(partition, bucket), this.formatIdentifier, this.dataFilePrefix, this.changelogFilePrefix, this.fileSuffixIncludeCompression, this.fileCompression, this.createExternalPathProvider(partition, bucket));
    }

    public DataFilePathFactory createFormatTableDataFilePathFactory(BinaryRow partition) {
        return new DataFilePathFactory(this.partitionPath(partition), this.formatIdentifier, this.dataFilePrefix, this.changelogFilePrefix, this.fileSuffixIncludeCompression, this.fileCompression, this.createExternalPartitionPathProvider(partition));
    }

    private ExternalPathProvider createExternalPartitionPathProvider(BinaryRow partition) {
        if (this.externalPaths == null || this.externalPaths.isEmpty()) {
            return null;
        }
        return new ExternalPathProvider(this.externalPaths, this.partitionPath(partition));
    }

    public Path partitionPath(BinaryRow partition) {
        Path relativeBucketPath = null;
        String partitionPath = this.getPartitionString(partition);
        if (!partitionPath.isEmpty()) {
            relativeBucketPath = new Path(partitionPath);
        }
        if (this.dataFilePathDirectory != null) {
            relativeBucketPath = relativeBucketPath != null ? new Path(this.dataFilePathDirectory, relativeBucketPath) : new Path(this.dataFilePathDirectory);
        }
        return relativeBucketPath != null ? new Path(this.root, relativeBucketPath) : this.root;
    }

    @Nullable
    private ExternalPathProvider createExternalPathProvider(BinaryRow partition, int bucket) {
        if (this.externalPaths == null || this.externalPaths.isEmpty()) {
            return null;
        }
        return new ExternalPathProvider(this.externalPaths, this.relativeBucketPath(partition, bucket));
    }

    public List<Path> getExternalPaths() {
        return this.externalPaths;
    }

    public Path bucketPath(BinaryRow partition, int bucket) {
        return new Path(this.root, this.relativeBucketPath(partition, bucket));
    }

    public Path relativeBucketPath(BinaryRow partition, int bucket) {
        String bucketName = String.valueOf(bucket);
        if (bucket == -2) {
            bucketName = "postpone";
        }
        Path relativeBucketPath = new Path(BUCKET_PATH_PREFIX + bucketName);
        String partitionPath = this.getPartitionString(partition);
        if (!partitionPath.isEmpty()) {
            relativeBucketPath = new Path(partitionPath, relativeBucketPath);
        }
        if (this.dataFilePathDirectory != null) {
            relativeBucketPath = new Path(this.dataFilePathDirectory, relativeBucketPath);
        }
        return relativeBucketPath;
    }

    public String getPartitionString(BinaryRow partition) {
        return PartitionPathUtils.generatePartitionPath(this.partitionComputer.generatePartValues(Preconditions.checkNotNull(partition, "Partition row data is null. This is unexpected.")));
    }

    public List<Path> getHierarchicalPartitionPath(BinaryRow partition) {
        return PartitionPathUtils.generateHierarchicalPartitionPaths(this.partitionComputer.generatePartValues(Preconditions.checkNotNull(partition, "Partition binary row is null. This is unexpected."))).stream().map(p -> new Path(this.root + "/" + p)).collect(Collectors.toList());
    }

    @VisibleForTesting
    public String uuid() {
        return this.uuid;
    }

    public PathFactory manifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return FileStorePathFactory.this.newManifestFile();
            }

            @Override
            public Path toPath(String fileName) {
                return FileStorePathFactory.this.toManifestFilePath(fileName);
            }
        };
    }

    public PathFactory manifestListFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return FileStorePathFactory.this.newManifestList();
            }

            @Override
            public Path toPath(String fileName) {
                return FileStorePathFactory.this.toManifestListPath(fileName);
            }
        };
    }

    public PathFactory indexManifestFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return this.toPath(FileStorePathFactory.INDEX_MANIFEST_PREFIX + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.indexManifestCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.manifestPath(), fileName);
            }
        };
    }

    public IndexPathFactory indexFileFactory(BinaryRow partition, int bucket) {
        if (this.indexFileInDataFileDir) {
            DataFilePathFactory dataFilePathFactory = this.createDataFilePathFactory(partition, bucket);
            return new IndexInDataFileDirPathFactory(this.uuid, this.indexFileCount, dataFilePathFactory);
        }
        return new IndexPathFactory(){

            @Override
            public Path newPath() {
                return this.toPath(FileStorePathFactory.INDEX_PREFIX + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.indexFileCount.getAndIncrement());
            }

            @Override
            public Path toPath(IndexFileMeta file) {
                return this.toPath(file.fileName());
            }

            @Override
            public boolean isExternalPath() {
                return false;
            }

            private Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.indexPath(), fileName);
            }
        };
    }

    public PathFactory statsFileFactory() {
        return new PathFactory(){

            @Override
            public Path newPath() {
                return this.toPath(FileStorePathFactory.STATISTICS_PREFIX + FileStorePathFactory.this.uuid + "-" + FileStorePathFactory.this.statsFileCount.getAndIncrement());
            }

            @Override
            public Path toPath(String fileName) {
                return new Path(FileStorePathFactory.this.statisticsPath(), fileName);
            }
        };
    }

    public static Function<String, FileStorePathFactory> createFormatPathFactories(CoreOptions options, BiFunction<CoreOptions, String, FileStorePathFactory> formatPathFactory) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return format -> map.computeIfAbsent(format, k -> (FileStorePathFactory)formatPathFactory.apply(options, (String)format));
    }
}

