/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;

public class FileReadUtils {
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 4096;

    public static String readFileUtf8(File file) throws IOException {
        return FileReadUtils.readFile(file, "UTF-8");
    }

    public static String readFile(File file, String charsetName) throws IOException {
        byte[] bytes = FileReadUtils.readAllBytes(file.toPath());
        return new String(bytes, charsetName);
    }

    public static byte[] readAllBytes(Path path) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
            byte[] byArray;
            block13: {
                InputStream in = Channels.newInputStream(channel);
                try {
                    long size = channel.size();
                    if (size > 0x7FFFFFF7L) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    byArray = FileReadUtils.read(in, (int)size);
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return byArray;
        }
    }

    private static byte[] read(InputStream source, int initialSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, Math.min(capacity - nread, 4096))) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 4096);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }
}

