/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.manifest.SimpleFileEntryWithDV;
import org.apache.paimon.utils.Preconditions;

public class ConflictDeletionUtils {
    public static List<SimpleFileEntry> buildBaseEntriesWithDV(List<SimpleFileEntry> baseEntries, List<IndexManifestEntry> baseIndexEntries) {
        if (baseEntries.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> fileNameToDVFileName = new HashMap<String, String>();
        for (IndexManifestEntry indexManifestEntry : baseIndexEntries) {
            IndexFileMeta indexFile;
            if (indexManifestEntry.kind().equals((Object)FileKind.DELETE) || (indexFile = indexManifestEntry.indexFile()).dvRanges() == null) continue;
            for (DeletionVectorMeta value : indexFile.dvRanges().values()) {
                Preconditions.checkState(!fileNameToDVFileName.containsKey(value.dataFileName()), "One file should correspond to only one dv entry.");
                fileNameToDVFileName.put(value.dataFileName(), indexFile.fileName());
            }
        }
        ArrayList<SimpleFileEntry> entriesWithDV = new ArrayList<SimpleFileEntry>(baseEntries.size());
        for (SimpleFileEntry fileEntry : baseEntries) {
            entriesWithDV.add(new SimpleFileEntryWithDV(fileEntry, (String)fileNameToDVFileName.get(fileEntry.fileName())));
        }
        return entriesWithDV;
    }

    public static List<SimpleFileEntry> buildDeltaEntriesWithDV(List<SimpleFileEntry> baseEntries, List<SimpleFileEntry> deltaEntries, List<IndexManifestEntry> deltaIndexEntries) {
        if (deltaEntries.isEmpty() && deltaIndexEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SimpleFileEntry> entriesWithDV = new ArrayList<SimpleFileEntry>(deltaEntries.size());
        HashMap fileNameToDVEntry = new HashMap();
        for (IndexManifestEntry indexManifestEntry : deltaIndexEntries) {
            if (indexManifestEntry.indexFile().dvRanges() == null) continue;
            for (DeletionVectorMeta meta : indexManifestEntry.indexFile().dvRanges().values()) {
                fileNameToDVEntry.putIfAbsent(meta.dataFileName(), new ArrayList());
                ((List)fileNameToDVEntry.get(meta.dataFileName())).add(indexManifestEntry);
            }
        }
        HashSet fileNotInDeltaEntries = new HashSet(fileNameToDVEntry.keySet());
        for (SimpleFileEntry fileEntry : deltaEntries) {
            if (fileNameToDVEntry.containsKey(fileEntry.fileName())) {
                List dvs = (List)fileNameToDVEntry.get(fileEntry.fileName());
                Preconditions.checkState(dvs.size() == 1, "Delta entry only can have one dv file");
                entriesWithDV.add(new SimpleFileEntryWithDV(fileEntry, ((IndexManifestEntry)dvs.get(0)).indexFile().fileName()));
                fileNotInDeltaEntries.remove(fileEntry.fileName());
                continue;
            }
            entriesWithDV.add(new SimpleFileEntryWithDV(fileEntry, null));
        }
        if (!fileNotInDeltaEntries.isEmpty()) {
            HashMap<String, SimpleFileEntry> hashMap = new HashMap<String, SimpleFileEntry>();
            for (SimpleFileEntry baseEntry : baseEntries) {
                if (!baseEntry.kind().equals((Object)FileKind.ADD)) continue;
                hashMap.put(baseEntry.fileName(), baseEntry);
            }
            for (String fileName : fileNotInDeltaEntries) {
                SimpleFileEntryWithDV simpleFileEntry = (SimpleFileEntryWithDV)hashMap.get(fileName);
                Preconditions.checkState(simpleFileEntry != null, String.format("Trying to create deletion vector on file %s which is not previously added.", fileName));
                List dvEntries = (List)fileNameToDVEntry.get(fileName);
                for (IndexManifestEntry dvEntry : dvEntries) {
                    entriesWithDV.add(new SimpleFileEntryWithDV(dvEntry.kind().equals((Object)FileKind.ADD) ? simpleFileEntry : simpleFileEntry.toDelete(), dvEntry.indexFile().fileName()));
                }
                if (dvEntries.size() != 1 || !((IndexManifestEntry)dvEntries.get(0)).kind().equals((Object)FileKind.ADD)) continue;
                entriesWithDV.add(new SimpleFileEntryWithDV(simpleFileEntry.toDelete(), null));
            }
        }
        return entriesWithDV;
    }
}

