/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.fs.Path;

public class CompactedChangelogPathResolver {
    public static boolean isCompactedChangelogPath(Path path) {
        return path.getName().startsWith("compacted-changelog-");
    }

    public static Path resolveCompactedChangelogPath(Path path) {
        if (!CompactedChangelogPathResolver.isCompactedChangelogPath(path)) {
            return path;
        }
        return CompactedChangelogPathResolver.decodePath(path).getPath();
    }

    public static DecodeResult decodePath(Path path) {
        String[] nameAndFormat = path.getName().split("\\.");
        String[] names = nameAndFormat[0].split("\\$");
        String[] split = names[1].split("-");
        if (split.length == 2) {
            return new DecodeResult(path, 0L, Long.parseLong(split[1]));
        }
        Path realPath = new Path(path.getParent().getParent(), "bucket-" + split[0] + "/" + names[0] + "$" + split[0] + "-" + split[1] + "." + nameAndFormat[1]);
        return new DecodeResult(realPath, Long.parseLong(split[2]), Long.parseLong(split[3]));
    }

    public static class DecodeResult {
        private final Path path;
        private final long offset;
        private final long length;

        public DecodeResult(Path path, long offset, long length) {
            this.path = path;
            this.offset = offset;
            this.length = length;
        }

        public Path getPath() {
            return this.path;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getLength() {
            return this.length;
        }
    }
}

