/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.FunctionWithException;
import org.apache.paimon.utils.ThrowingConsumer;

public class CatalogBranchManager
implements BranchManager {
    private final CatalogLoader catalogLoader;
    private final Identifier identifier;

    public CatalogBranchManager(CatalogLoader catalogLoader, Identifier identifier) {
        this.catalogLoader = catalogLoader;
        this.identifier = identifier;
    }

    private void executePost(ThrowingConsumer<Catalog, Exception> func) {
        this.executeGet(catalog -> {
            try {
                func.accept((Catalog)catalog);
                return null;
            }
            catch (Catalog.BranchNotExistException e) {
                throw new IllegalArgumentException(String.format("Branch name '%s' doesn't exist.", e.branch()));
            }
            catch (Catalog.TagNotExistException e) {
                throw new IllegalArgumentException(String.format("Tag '%s' doesn't exist.", e.tag()));
            }
            catch (Catalog.BranchAlreadyExistException e) {
                throw new IllegalArgumentException(String.format("Branch name '%s' already exists..", e.branch()));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeGet(FunctionWithException<Catalog, T, Exception> func) {
        try (Catalog catalog = this.catalogLoader.load();){
            Catalog t = func.apply(catalog);
            return (T)t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createBranch(String branchName) {
        this.executePost(catalog -> catalog.createBranch(this.identifier, branchName, null));
    }

    @Override
    public void createBranch(String branchName, @Nullable String tagName) {
        this.executePost(catalog -> {
            BranchManager.validateBranch(branchName);
            catalog.createBranch(this.identifier, branchName, tagName);
        });
    }

    @Override
    public void dropBranch(String branchName) {
        this.executePost(catalog -> catalog.dropBranch(this.identifier, branchName));
    }

    @Override
    public void fastForward(String branchName) {
        this.executePost(catalog -> {
            BranchManager.fastForwardValidate(branchName, this.identifier.getBranchNameOrDefault());
            catalog.fastForward(this.identifier, branchName);
        });
    }

    @Override
    public List<String> branches() {
        return this.executeGet(catalog -> catalog.listBranches(this.identifier));
    }
}

