/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tag;

import java.io.IOException;
import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.TableSnapshot;
import org.apache.paimon.utils.SnapshotLoader;

public class SnapshotLoaderImpl
implements SnapshotLoader {
    private final CatalogLoader catalogLoader;
    private final Identifier identifier;

    public SnapshotLoaderImpl(CatalogLoader catalogLoader, Identifier identifier) {
        this.catalogLoader = catalogLoader;
        this.identifier = identifier;
    }

    @Override
    public Optional<Snapshot> load() throws IOException {
        Optional<Snapshot> optional;
        block9: {
            Catalog catalog = this.catalogLoader.load();
            try {
                optional = catalog.loadSnapshot(this.identifier).map(TableSnapshot::snapshot);
                if (catalog == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (catalog != null) {
                        try {
                            catalog.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catalog.close();
        }
        return optional;
    }

    @Override
    public void rollback(Instant instant) throws IOException {
        try (Catalog catalog = this.catalogLoader.load();){
            catalog.rollbackTo(this.identifier, instant);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SnapshotLoader copyWithBranch(String branch) {
        return new SnapshotLoaderImpl(this.catalogLoader, new Identifier(this.identifier.getDatabaseName(), this.identifier.getTableName(), branch));
    }
}

