/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.EmptyRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class StatisticTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String STATISTICS = "statistics";
    private static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "snapshot_id", new BigIntType(false)), new DataField(1, "schema_id", new BigIntType(false)), new DataField(2, "mergedRecordCount", new BigIntType(true)), new DataField(3, "mergedRecordSize", new BigIntType(true)), new DataField(4, "colstat", SerializationUtils.newStringType(true))));
    private final FileStoreTable dataTable;

    public StatisticTable(FileStoreTable dataTable) {
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.dataTable.name() + "$statistics";
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("snapshot_id");
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new StatisticScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new StatisticRead(this.dataTable);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new StatisticTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private static class StatisticRead
    implements InnerTableRead {
        private RowType readType;
        private final FileStoreTable dataTable;

        public StatisticRead(FileStoreTable dataTable) {
            this.dataTable = dataTable;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof StatisticSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Optional<Statistics> statisticsOptional = this.dataTable.statistics();
            if (statisticsOptional.isPresent()) {
                Statistics statistics = statisticsOptional.get();
                Iterator<Statistics> statisticsIterator = Collections.singletonList(statistics).iterator();
                Iterator rows = Iterators.transform(statisticsIterator, this::toRow);
                if (this.readType != null) {
                    rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
                }
                return new IteratorRecordReader<InternalRow>(rows);
            }
            return new EmptyRecordReader<InternalRow>();
        }

        private InternalRow toRow(Statistics statistics) {
            return GenericRow.of(statistics.snapshotId(), statistics.schemaId(), statistics.mergedRecordCount().getAsLong(), statistics.mergedRecordSize().getAsLong(), BinaryString.fromString(JsonSerdeUtil.toJson(statistics.colStats())));
        }
    }

    private static class StatisticSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private StatisticSplit(Path location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatisticSplit that = (StatisticSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class StatisticScan
    extends ReadOnceTableScan {
        private StatisticScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new StatisticSplit(StatisticTable.this.dataTable.location()));
        }
    }
}

