/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class RowTrackingTable
implements DataTable,
ReadonlyTable {
    public static final String ROW_TRACKING = "row_tracking";
    private final FileStoreTable wrapped;

    public RowTrackingTable(FileStoreTable wrapped) {
        this.wrapped = wrapped;
        if (!this.coreOptions().rowTrackingEnabled()) {
            throw new IllegalArgumentException("Table " + wrapped.name() + " does not support row tracking, please enable 'row-tracking.enabled' option to use 'with_metadata' table.");
        }
    }

    @Override
    public Optional<Snapshot> latestSnapshot() {
        return this.wrapped.latestSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public String name() {
        return this.wrapped.name() + "$row_tracking";
    }

    @Override
    public RowType rowType() {
        return SpecialFields.rowTypeWithRowTracking(this.wrapped.rowType());
    }

    @Override
    public List<String> partitionKeys() {
        return this.wrapped.partitionKeys();
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public DataTableScan newScan() {
        return this.wrapped.newScan();
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        return this.wrapped.newStreamScan();
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public ChangelogManager changelogManager() {
        return this.wrapped.changelogManager();
    }

    @Override
    public ConsumerManager consumerManager() {
        return this.wrapped.consumerManager();
    }

    @Override
    public SchemaManager schemaManager() {
        return this.wrapped.schemaManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new RowTrackingTable(this.wrapped.switchToBranch(branchName));
    }

    @Override
    public InnerTableRead newRead() {
        return this.wrapped.newRead().withReadType(this.rowType());
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new RowTrackingTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }
}

