/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.InPredicateVisitor;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafPredicateExtractor;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class BranchesTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String BRANCHES = "branches";
    private static final String BRANCH_NAME = "branch_name";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "branch_name", SerializationUtils.newStringType(false)), new DataField(1, "create_time", new TimestampType(false, 3))));
    private final FileIO fileIO;
    private final Path location;
    private final FileStoreTable dataTable;

    public BranchesTable(FileStoreTable dataTable) {
        this.fileIO = dataTable.fileIO();
        this.location = dataTable.location();
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$branches";
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList(BRANCH_NAME);
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new BranchesScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new BranchesRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new BranchesTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private static class BranchesRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private RowType readType;

        public BranchesRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            Iterator<InternalRow> rows;
            if (!(split instanceof BranchesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((BranchesSplit)split).location;
            Predicate predicate = ((BranchesSplit)split).branchPredicate;
            FileStoreTable table = FileStoreTableFactory.create(this.fileIO, location);
            try {
                rows = this.branches(table, predicate).iterator();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow createBranchRow(String branchName, Path tablePath) throws IOException {
            String branchPath = BranchManager.branchPath(tablePath, branchName);
            long creationTime = this.fileIO.getFileStatus(new Path(branchPath)).getModificationTime();
            return GenericRow.of(BinaryString.fromString(branchName), Timestamp.fromLocalDateTime(DateTimeUtils.toLocalDateTime(creationTime)));
        }

        private List<InternalRow> branches(FileStoreTable table, Predicate predicate) throws IOException {
            ArrayList<InternalRow> result;
            block4: {
                Path tablePath;
                BranchManager branchManager;
                block3: {
                    CompoundPredicate compoundPredicate;
                    String equalValue;
                    branchManager = table.branchManager();
                    tablePath = table.location();
                    result = new ArrayList<InternalRow>();
                    if (predicate == null) break block3;
                    if (predicate instanceof LeafPredicate && ((LeafPredicate)predicate).function() instanceof Equal && ((LeafPredicate)predicate).literals().get(0) instanceof BinaryString && predicate.visit(LeafPredicateExtractor.INSTANCE).get(BranchesTable.BRANCH_NAME) != null && branchManager.branchExists(equalValue = ((LeafPredicate)predicate).literals().get(0).toString())) {
                        result.add(this.createBranchRow(equalValue, tablePath));
                    }
                    if (!(predicate instanceof CompoundPredicate) || !((compoundPredicate = (CompoundPredicate)predicate).function() instanceof Or)) break block4;
                    ArrayList branchNames = new ArrayList();
                    InPredicateVisitor.extractInElements(predicate, BranchesTable.BRANCH_NAME).ifPresent(e -> e.stream().map(Object::toString).forEach(branchNames::add));
                    for (String branchName : branchNames) {
                        if (!branchManager.branchExists(branchName)) continue;
                        result.add(this.createBranchRow(branchName, tablePath));
                    }
                    break block4;
                }
                List<String> branches = branchManager.branches();
                for (String branch : branches) {
                    result.add(this.createBranchRow(branch, tablePath));
                }
            }
            return result;
        }
    }

    private static class BranchesSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;
        @Nullable
        private final Predicate branchPredicate;

        private BranchesSplit(Path location, @Nullable Predicate branchPredicate) {
            this.location = location;
            this.branchPredicate = branchPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BranchesSplit that = (BranchesSplit)o;
            return Objects.equals(this.location, that.location) && Objects.equals(this.branchPredicate, that.branchPredicate);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class BranchesScan
    extends ReadOnceTableScan {
        @Nullable
        private Predicate branchPredicate;

        private BranchesScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            if (predicate == null) {
                return this;
            }
            this.branchPredicate = predicate;
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new BranchesSplit(BranchesTable.this.location, this.branchPredicate));
        }
    }
}

