/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.HashSet;
import java.util.Set;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.ListUtils;

public class PushDownUtils {
    public static boolean minmaxAvailable(DataType type) {
        return type instanceof BooleanType || type instanceof TinyIntType || type instanceof SmallIntType || type instanceof IntType || type instanceof BigIntType || type instanceof FloatType || type instanceof DoubleType || type instanceof DateType;
    }

    public static boolean minmaxAvailable(DataSplit split, Set<String> columns) {
        if (ListUtils.isNullOrEmpty(columns)) {
            return false;
        }
        if (!split.rawConvertible()) {
            return false;
        }
        return split.dataFiles().stream().map(DataFileMeta::valueStatsCols).allMatch(valueStatsCols -> valueStatsCols == null || new HashSet(valueStatsCols).containsAll(columns));
    }
}

