/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueFileStore;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.mergetree.compact.LookupMergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.PrimaryKeyTableUtils;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.MergeTreeSplitGenerator;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowKindFilter;

public class PrimaryKeyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient KeyValueFileStore lazyStore;

    @VisibleForTesting
    PrimaryKeyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema) {
        this(fileIO, path, tableSchema, CatalogEnvironment.empty());
    }

    public PrimaryKeyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        super(fileIO, path, tableSchema, catalogEnvironment);
    }

    public KeyValueFileStore store() {
        if (this.lazyStore == null) {
            RowType rowType = this.tableSchema.logicalRowType();
            CoreOptions options = CoreOptions.fromMap(this.tableSchema.options());
            PrimaryKeyTableUtils.PrimaryKeyFieldsExtractor extractor = PrimaryKeyTableUtils.PrimaryKeyFieldsExtractor.EXTRACTOR;
            RowType keyType = new RowType(extractor.keyFields(this.tableSchema));
            MergeFunctionFactory<KeyValue> mfFactory = PrimaryKeyTableUtils.createMergeFunctionFactory(this.tableSchema, extractor);
            if (options.needLookup()) {
                mfFactory = LookupMergeFunction.wrap(mfFactory, options, keyType, rowType);
            }
            this.lazyStore = new KeyValueFileStore(this.fileIO(), this.schemaManager(), this.tableSchema, this.tableSchema.crossPartitionUpdate(), options, this.tableSchema.logicalPartitionType(), PrimaryKeyTableUtils.addKeyNamePrefix(this.tableSchema.logicalBucketKeyType()), keyType, rowType, extractor, mfFactory, this.name(), this.catalogEnvironment);
        }
        return this.lazyStore;
    }

    @Override
    protected SplitGenerator splitGenerator() {
        CoreOptions options = this.store().options();
        return new MergeTreeSplitGenerator(this.store().newKeyComparator(), options.splitTargetSize(), options.splitOpenFileCost(), options.deletionVectorsEnabled(), options.mergeEngine());
    }

    @Override
    public boolean supportStreamingReadOverwrite() {
        return new CoreOptions(this.tableSchema.options()).streamingReadOverwrite();
    }

    @Override
    protected BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer() {
        return (scan, predicate) -> {
            List<Predicate> keyFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.tableSchema.fieldNames(), this.tableSchema.trimmedPrimaryKeys());
            if (!keyFilters.isEmpty()) {
                ((KeyValueFileStoreScan)scan).withKeyFilter(PredicateBuilder.and(keyFilters));
            }
            ((KeyValueFileStoreScan)scan).withValueFilter((Predicate)predicate);
        };
    }

    @Override
    public InnerTableRead newRead() {
        return new KeyValueTableRead(() -> this.store().newRead(), () -> this.store().newBatchRawFileRead(), this.schema());
    }

    @Override
    public TableWriteImpl<KeyValue> newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public TableWriteImpl<KeyValue> newWrite(String commitUser, @Nullable Integer writeId) {
        KeyValue kv = new KeyValue();
        return new TableWriteImpl<KeyValue>(this.rowType(), this.store().newWrite(commitUser, writeId), this.createRowKeyExtractor(), (record, rowKind) -> kv.replace(record.primaryKey(), -1L, rowKind, record.row()), this.rowKindGenerator(), RowKindFilter.of(this.coreOptions()));
    }

    @Override
    public LocalTableQuery newLocalTableQuery() {
        return new LocalTableQuery(this);
    }

    @Override
    @Nullable
    protected Runnable newExpireRunnable() {
        if (this.coreOptions().bucket() == -2) {
            return null;
        }
        return super.newExpireRunnable();
    }
}

