/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.AppendOnlyFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.AppendOnlyFileStoreScan;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.AbstractFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.source.AppendOnlySplitGenerator;
import org.apache.paimon.table.source.AppendTableRead;
import org.apache.paimon.table.source.DataEvolutionSplitGenerator;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.splitread.AppendTableRawFileSplitReadProvider;
import org.apache.paimon.table.source.splitread.DataEvolutionSplitReadProvider;
import org.apache.paimon.table.source.splitread.SplitReadConfig;
import org.apache.paimon.table.source.splitread.SplitReadProvider;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowKindFilter;

public class AppendOnlyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private transient AppendOnlyFileStore lazyStore;

    AppendOnlyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema) {
        this(fileIO, path, tableSchema, CatalogEnvironment.empty());
    }

    public AppendOnlyFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        super(fileIO, path, tableSchema, catalogEnvironment);
    }

    public AppendOnlyFileStore store() {
        if (this.lazyStore == null) {
            this.lazyStore = new AppendOnlyFileStore(this.fileIO, this.schemaManager(), this.tableSchema, new CoreOptions(this.tableSchema.options()), this.tableSchema.logicalPartitionType(), this.tableSchema.logicalBucketKeyType(), this.tableSchema.logicalRowType().notNull(), this.name(), this.catalogEnvironment);
        }
        return this.lazyStore;
    }

    @Override
    protected SplitGenerator splitGenerator() {
        long targetSplitSize = this.store().options().splitTargetSize();
        long openFileCost = this.store().options().splitOpenFileCost();
        return this.coreOptions().dataEvolutionEnabled() ? new DataEvolutionSplitGenerator(targetSplitSize, openFileCost) : new AppendOnlySplitGenerator(targetSplitSize, openFileCost, this.bucketMode());
    }

    @Override
    public boolean supportStreamingReadOverwrite() {
        return new CoreOptions(this.tableSchema.options()).streamingReadAppendOverwrite();
    }

    @Override
    protected BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer() {
        return (scan, predicate) -> ((AppendOnlyFileStoreScan)scan).withFilter((Predicate)predicate);
    }

    @Override
    public InnerTableRead newRead() {
        ArrayList<Function<SplitReadConfig, SplitReadProvider>> providerFactories = new ArrayList<Function<SplitReadConfig, SplitReadProvider>>();
        if (this.coreOptions().dataEvolutionEnabled()) {
            providerFactories.add(config -> new DataEvolutionSplitReadProvider(() -> this.store().newDataEvolutionRead(), (SplitReadConfig)config));
        }
        providerFactories.add(config -> new AppendTableRawFileSplitReadProvider(() -> this.store().newRead(), (SplitReadConfig)config));
        return new AppendTableRead(providerFactories, this.schema());
    }

    @Override
    public TableWriteImpl<InternalRow> newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public TableWriteImpl<InternalRow> newWrite(String commitUser, @Nullable Integer writeId) {
        BaseAppendFileStoreWrite writer = this.store().newWrite(commitUser, writeId);
        return new TableWriteImpl<InternalRow>(this.rowType(), writer, this.createRowKeyExtractor(), (record, rowKind) -> {
            Preconditions.checkState(rowKind.isAdd(), "Append only writer can not accept row with RowKind %s", new Object[]{rowKind});
            return record.row();
        }, this.rowKindGenerator(), RowKindFilter.of(this.coreOptions()));
    }

    @Override
    public LocalTableQuery newLocalTableQuery() {
        throw new UnsupportedOperationException();
    }
}

