/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.FileNotFoundException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.SchemaValidation;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.ExpireChangelogImpl;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.ExpireSnapshotsImpl;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Instant;
import org.apache.paimon.table.PrimaryKeyFileStoreTable;
import org.apache.paimon.table.RollbackHelper;
import org.apache.paimon.table.sink.AppendTableRowKeyExtractor;
import org.apache.paimon.table.sink.DynamicBucketRowKeyExtractor;
import org.apache.paimon.table.sink.FixedBucketRowKeyExtractor;
import org.apache.paimon.table.sink.FixedBucketWriteSelector;
import org.apache.paimon.table.sink.PostponeBucketRowKeyExtractor;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.table.sink.RowKindGenerator;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.WriteSelector;
import org.apache.paimon.table.source.DataTableBatchScan;
import org.apache.paimon.table.source.DataTableStreamScan;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.SnapshotReaderImpl;
import org.apache.paimon.table.source.snapshot.TimeTravelUtil;
import org.apache.paimon.tag.TagAutoManager;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.CatalogBranchManager;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.FileSystemBranchManager;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.SnapshotNotExistException;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TagManager;

abstract class AbstractFileStoreTable
implements FileStoreTable {
    private static final long serialVersionUID = 1L;
    protected final FileIO fileIO;
    protected final Path path;
    protected final TableSchema tableSchema;
    protected final CatalogEnvironment catalogEnvironment;
    @Nullable
    protected transient SegmentsCache<Path> manifestCache;
    @Nullable
    protected transient Cache<Path, Snapshot> snapshotCache;
    @Nullable
    protected transient Cache<String, Statistics> statsCache;

    protected AbstractFileStoreTable(FileIO fileIO, Path path, TableSchema tableSchema, CatalogEnvironment catalogEnvironment) {
        this.fileIO = fileIO;
        this.path = path;
        if (!tableSchema.options().containsKey(CoreOptions.PATH.key())) {
            HashMap<String, String> newOptions = new HashMap<String, String>(tableSchema.options());
            newOptions.put(CoreOptions.PATH.key(), path.toString());
            tableSchema = tableSchema.copy(newOptions);
        }
        this.tableSchema = tableSchema;
        this.catalogEnvironment = catalogEnvironment;
    }

    public String currentBranch() {
        return CoreOptions.branch(this.options());
    }

    @Override
    public void setManifestCache(SegmentsCache<Path> manifestCache) {
        this.manifestCache = manifestCache;
        this.store().setManifestCache(manifestCache);
    }

    @Override
    @Nullable
    public SegmentsCache<Path> getManifestCache() {
        return this.manifestCache;
    }

    @Override
    public void setSnapshotCache(Cache<Path, Snapshot> cache) {
        this.snapshotCache = cache;
        this.store().setSnapshotCache(cache);
    }

    @Override
    public void setStatsCache(Cache<String, Statistics> cache) {
        this.statsCache = cache;
    }

    @Override
    public Optional<Snapshot> latestSnapshot() {
        Snapshot snapshot = this.store().snapshotManager().latestSnapshot();
        return Optional.ofNullable(snapshot);
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.store().snapshotManager().snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.store().manifestListFactory().create();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.store().manifestFileFactory().create();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.store().indexManifestFileFactory().create();
    }

    @Override
    public String name() {
        return this.identifier().getObjectName();
    }

    @Override
    public String fullName() {
        return this.identifier().getFullName();
    }

    public Identifier identifier() {
        Identifier identifier = this.catalogEnvironment.identifier();
        return identifier == null ? SchemaManager.identifierFromPath(this.location().toUri().toString(), true, this.currentBranch()) : identifier;
    }

    @Override
    public String uuid() {
        if (this.catalogEnvironment.uuid() != null) {
            return this.catalogEnvironment.uuid();
        }
        long earliestCreationTime = this.schemaManager().earliestCreationTime();
        return this.fullName() + "." + earliestCreationTime;
    }

    @Override
    public Optional<Statistics> statistics() {
        Snapshot snapshot = TimeTravelUtil.tryTravelOrLatest(this);
        if (snapshot != null) {
            Statistics stats;
            String file = snapshot.statistics();
            if (file == null) {
                return Optional.empty();
            }
            if (this.statsCache != null && (stats = this.statsCache.getIfPresent(file)) != null) {
                return Optional.of(stats);
            }
            stats = this.store().newStatsFileHandler().readStats(file);
            if (this.statsCache != null) {
                this.statsCache.put(file, stats);
            }
            return Optional.of(stats);
        }
        return Optional.empty();
    }

    @Override
    public Optional<WriteSelector> newWriteSelector() {
        switch (this.bucketMode()) {
            case HASH_FIXED: {
                return Optional.of(new FixedBucketWriteSelector(this.schema()));
            }
            case BUCKET_UNAWARE: 
            case POSTPONE_MODE: {
                return Optional.empty();
            }
        }
        throw new UnsupportedOperationException("Currently, write selector does not support table mode: " + this.bucketMode());
    }

    @Override
    public CatalogEnvironment catalogEnvironment() {
        return this.catalogEnvironment;
    }

    @Override
    public RowKeyExtractor createRowKeyExtractor() {
        switch (this.bucketMode()) {
            case HASH_FIXED: {
                return new FixedBucketRowKeyExtractor(this.schema());
            }
            case HASH_DYNAMIC: 
            case KEY_DYNAMIC: {
                return new DynamicBucketRowKeyExtractor(this.schema());
            }
            case BUCKET_UNAWARE: {
                return new AppendTableRowKeyExtractor(this.schema());
            }
            case POSTPONE_MODE: {
                return new PostponeBucketRowKeyExtractor(this.schema());
            }
        }
        throw new UnsupportedOperationException("Unsupported mode: " + this.bucketMode());
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return new SnapshotReaderImpl(this.store().newScan(), this.tableSchema, this.coreOptions(), this.snapshotManager(), this.changelogManager(), this.splitGenerator(), this.nonPartitionFilterConsumer(), this.store().pathFactory(), this.name(), this.store().newIndexFileHandler());
    }

    @Override
    public DataTableBatchScan newScan() {
        return new DataTableBatchScan(this.tableSchema, this.schemaManager(), this.coreOptions(), this.newSnapshotReader(), this.catalogEnvironment.tableQueryAuth(this.coreOptions()));
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        return new DataTableStreamScan(this.tableSchema, this.coreOptions(), this.newSnapshotReader(), this.snapshotManager(), this.changelogManager(), this.supportStreamingReadOverwrite(), this.catalogEnvironment.tableQueryAuth(this.coreOptions()), !this.tableSchema.primaryKeys().isEmpty());
    }

    protected abstract SplitGenerator splitGenerator();

    protected abstract BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer();

    @Override
    public FileStoreTable copy(Map<String, String> dynamicOptions) {
        this.checkImmutability(dynamicOptions);
        return this.copyInternal(dynamicOptions, true);
    }

    @Override
    public FileStoreTable copyWithoutTimeTravel(Map<String, String> dynamicOptions) {
        this.checkImmutability(dynamicOptions);
        return this.copyInternal(dynamicOptions, false);
    }

    private void checkImmutability(Map<String, String> dynamicOptions) {
        Map<String, String> oldOptions = this.tableSchema.options();
        dynamicOptions.forEach((k, newValue) -> {
            String oldValue = (String)oldOptions.get(k);
            if (!Objects.equals(oldValue, newValue)) {
                SchemaManager.checkAlterTableOption(k, oldValue, newValue, true);
                if (CoreOptions.BUCKET.key().equals(k)) {
                    throw new UnsupportedOperationException("Cannot change bucket number through dynamic options. You might need to rescale bucket.");
                }
            }
        });
    }

    protected FileStoreTable copyInternal(Map<String, String> dynamicOptions, boolean tryTimeTravel) {
        HashMap<String, String> options = new HashMap<String, String>(this.tableSchema.options());
        dynamicOptions.forEach((k, v) -> {
            if (v == null) {
                options.remove(k);
            } else {
                options.put((String)k, (String)v);
            }
        });
        Options newOptions = Options.fromMap(options);
        newOptions.set(CoreOptions.PATH, this.path.toString());
        CoreOptions.setDefaultValues(newOptions);
        TableSchema newTableSchema = this.tableSchema.copy(newOptions.toMap());
        if (tryTimeTravel) {
            newTableSchema = this.tryTimeTravel(newOptions).orElse(newTableSchema);
        }
        SchemaValidation.validateTableSchema(newTableSchema);
        return this.copy(newTableSchema);
    }

    @Override
    public FileStoreTable copyWithLatestSchema() {
        Optional<TableSchema> optionalLatestSchema = this.schemaManager().latest();
        if (optionalLatestSchema.isPresent()) {
            Map<String, String> options = this.tableSchema.options();
            TableSchema newTableSchema = optionalLatestSchema.get();
            newTableSchema = newTableSchema.copy(options);
            SchemaValidation.validateTableSchema(newTableSchema);
            return this.copy(newTableSchema);
        }
        return this;
    }

    @Override
    public FileStoreTable copy(TableSchema newTableSchema) {
        AbstractFileStoreTable copied;
        AbstractFileStoreTable abstractFileStoreTable = copied = newTableSchema.primaryKeys().isEmpty() ? new AppendOnlyFileStoreTable(this.fileIO, this.path, newTableSchema, this.catalogEnvironment) : new PrimaryKeyFileStoreTable(this.fileIO, this.path, newTableSchema, this.catalogEnvironment);
        if (this.snapshotCache != null) {
            copied.setSnapshotCache(this.snapshotCache);
        }
        if (this.manifestCache != null) {
            copied.setManifestCache(this.manifestCache);
        }
        if (this.statsCache != null) {
            copied.setStatsCache(this.statsCache);
        }
        return copied;
    }

    @Override
    public SchemaManager schemaManager() {
        return new SchemaManager(this.fileIO(), this.path, this.currentBranch());
    }

    @Override
    public CoreOptions coreOptions() {
        return this.store().options();
    }

    @Override
    public FileIO fileIO() {
        return this.fileIO;
    }

    @Override
    public Path location() {
        return this.path;
    }

    @Override
    public TableSchema schema() {
        return this.tableSchema;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.store().snapshotManager();
    }

    @Override
    public ChangelogManager changelogManager() {
        return this.store().changelogManager();
    }

    @Override
    public ExpireSnapshots newExpireSnapshots() {
        return new ExpireSnapshotsImpl(this.snapshotManager(), this.changelogManager(), this.store().newSnapshotDeletion(), this.store().newTagManager());
    }

    @Override
    public ExpireSnapshots newExpireChangelog() {
        return new ExpireChangelogImpl(this.snapshotManager(), this.changelogManager(), this.tagManager(), this.store().newChangelogDeletion());
    }

    @Override
    public TableCommitImpl newCommit(String commitUser) {
        CoreOptions options = this.coreOptions();
        return new TableCommitImpl(this.store().newCommit(commitUser, this), this.newExpireRunnable(), options.writeOnly() ? null : this.store().newPartitionExpire(commitUser, this), options.writeOnly() ? null : this.store().newTagAutoManager(this), CoreOptions.fromMap(this.options()).consumerExpireTime(), new ConsumerManager(this.fileIO, this.path, this.snapshotManager().branch()), options.snapshotExpireExecutionMode(), this.name(), options.forceCreatingSnapshot(), options.fileOperationThreadNum());
    }

    @Override
    public ConsumerManager consumerManager() {
        return new ConsumerManager(this.fileIO, this.path, this.snapshotManager().branch());
    }

    @Nullable
    protected Runnable newExpireRunnable() {
        CoreOptions options = this.coreOptions();
        Runnable snapshotExpire = null;
        if (!options.writeOnly()) {
            boolean changelogDecoupled = options.changelogLifecycleDecoupled();
            ExpireConfig expireConfig = options.expireConfig();
            ExpireSnapshots expireChangelog = this.newExpireChangelog().config(expireConfig);
            ExpireSnapshots expireSnapshots = this.newExpireSnapshots().config(expireConfig);
            snapshotExpire = () -> {
                expireSnapshots.expire();
                if (changelogDecoupled) {
                    expireChangelog.expire();
                }
            };
        }
        return snapshotExpire;
    }

    private Optional<TableSchema> tryTimeTravel(Options options) {
        Snapshot snapshot;
        try {
            snapshot = TimeTravelUtil.tryTravelToSnapshot(options, this.snapshotManager(), this.tagManager()).orElse(null);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        if (snapshot == null) {
            return Optional.empty();
        }
        return Optional.of(this.schemaManager().schema(snapshot.schemaId()).copy(options.toMap()));
    }

    @Override
    public void rollbackTo(long snapshotId) {
        SnapshotManager snapshotManager = this.snapshotManager();
        try {
            snapshotManager.rollback(Instant.snapshot(snapshotId));
        }
        catch (UnsupportedOperationException e) {
            try {
                Snapshot snapshot = snapshotManager.tryGetSnapshot(snapshotId);
                this.rollbackHelper().cleanLargerThan(snapshot);
            }
            catch (FileNotFoundException ex) {
                TagManager tagManager = this.tagManager();
                SortedMap<Snapshot, List<String>> tags = tagManager.tags();
                for (Map.Entry<Snapshot, List<String>> entry : tags.entrySet()) {
                    if (entry.getKey().id() != snapshotId) continue;
                    this.rollbackTo(entry.getValue().get(0));
                    return;
                }
                throw new IllegalArgumentException(String.format("Rollback snapshot '%s' doesn't exist.", snapshotId), ex);
            }
        }
    }

    @Override
    public void rollbackTo(String tagName) {
        SnapshotManager snapshotManager = this.snapshotManager();
        try {
            snapshotManager.rollback(Instant.tag(tagName));
        }
        catch (UnsupportedOperationException e) {
            Snapshot taggedSnapshot = this.tagManager().getOrThrow(tagName).trimToSnapshot();
            RollbackHelper rollbackHelper = this.rollbackHelper();
            rollbackHelper.cleanLargerThan(taggedSnapshot);
            rollbackHelper.createSnapshotFileIfNeeded(taggedSnapshot);
        }
    }

    public Snapshot findSnapshot(long fromSnapshotId) throws SnapshotNotExistException {
        SnapshotManager snapshotManager = this.snapshotManager();
        Snapshot snapshot = null;
        if (snapshotManager.snapshotExists(fromSnapshotId)) {
            snapshot = snapshotManager.snapshot(fromSnapshotId);
        } else {
            SortedMap<Snapshot, List<String>> tags = this.tagManager().tags();
            for (Snapshot snap : tags.keySet()) {
                if (snap.id() == fromSnapshotId) {
                    snapshot = snap;
                    break;
                }
                if (snap.id() <= fromSnapshotId) continue;
                break;
            }
        }
        SnapshotNotExistException.checkNotNull(snapshot, String.format("Cannot create tag because given snapshot #%s doesn't exist.", fromSnapshotId));
        return snapshot;
    }

    @Override
    public TagAutoManager newTagAutoManager() {
        return this.store().newTagAutoManager(this);
    }

    @Override
    public void createTag(String tagName, long fromSnapshotId) {
        this.createTag(tagName, this.findSnapshot(fromSnapshotId), this.coreOptions().tagDefaultTimeRetained());
    }

    @Override
    public void createTag(String tagName, long fromSnapshotId, Duration timeRetained) {
        this.createTag(tagName, this.findSnapshot(fromSnapshotId), timeRetained);
    }

    @Override
    public void createTag(String tagName) {
        Snapshot latestSnapshot = this.snapshotManager().latestSnapshot();
        SnapshotNotExistException.checkNotNull(latestSnapshot, "Cannot create tag because latest snapshot doesn't exist.");
        this.createTag(tagName, latestSnapshot, this.coreOptions().tagDefaultTimeRetained());
    }

    @Override
    public void createTag(String tagName, Duration timeRetained) {
        Snapshot latestSnapshot = this.snapshotManager().latestSnapshot();
        SnapshotNotExistException.checkNotNull(latestSnapshot, "Cannot create tag because latest snapshot doesn't exist.");
        this.createTag(tagName, latestSnapshot, timeRetained);
    }

    private void createTag(String tagName, Snapshot fromSnapshot, @Nullable Duration timeRetained) {
        this.tagManager().createTag(fromSnapshot, tagName, timeRetained, this.store().createTagCallbacks(this), false);
    }

    @Override
    public void renameTag(String tagName, String targetTagName) {
        this.tagManager().renameTag(tagName, targetTagName);
    }

    @Override
    public void replaceTag(String tagName, @Nullable Long fromSnapshotId, @Nullable Duration timeRetained) {
        if (fromSnapshotId == null) {
            Snapshot latestSnapshot = this.snapshotManager().latestSnapshot();
            SnapshotNotExistException.checkNotNull(latestSnapshot, "Cannot replace tag because latest snapshot doesn't exist.");
            this.tagManager().replaceTag(latestSnapshot, tagName, timeRetained, this.store().createTagCallbacks(this));
        } else {
            this.tagManager().replaceTag(this.findSnapshot(fromSnapshotId), tagName, timeRetained, this.store().createTagCallbacks(this));
        }
    }

    @Override
    public void deleteTag(String tagName) {
        this.tagManager().deleteTag(tagName, this.store().newTagDeletion(), this.snapshotManager(), this.store().createTagCallbacks(this));
    }

    @Override
    public void createBranch(String branchName) {
        this.branchManager().createBranch(branchName);
    }

    @Override
    public void createBranch(String branchName, String tagName) {
        this.branchManager().createBranch(branchName, tagName);
    }

    @Override
    public void deleteBranch(String branchName) {
        String fallbackBranch = this.coreOptions().toConfiguration().get(CoreOptions.SCAN_FALLBACK_BRANCH);
        if (!StringUtils.isNullOrWhitespaceOnly(fallbackBranch) && branchName.equals(fallbackBranch)) {
            throw new IllegalArgumentException(String.format("can not delete the fallback branch. branchName to be deleted is %s. you have set 'scan.fallback-branch' = '%s'. you should reset 'scan.fallback-branch' before deleting this branch.", branchName, fallbackBranch));
        }
        this.branchManager().dropBranch(branchName);
    }

    @Override
    public void fastForward(String branchName) {
        this.branchManager().fastForward(branchName);
    }

    @Override
    public TagManager tagManager() {
        return new TagManager(this.fileIO, this.path, this.currentBranch(), this.coreOptions());
    }

    @Override
    public BranchManager branchManager() {
        if (this.catalogEnvironment.catalogLoader() != null && this.catalogEnvironment.supportsVersionManagement()) {
            return new CatalogBranchManager(this.catalogEnvironment.catalogLoader(), this.identifier());
        }
        return new FileSystemBranchManager(this.fileIO, this.path, this.snapshotManager(), this.tagManager(), this.schemaManager());
    }

    @Override
    public FileStoreTable switchToBranch(String branchName) {
        String targetBranch;
        String currentBranch = BranchManager.normalizeBranch(this.currentBranch());
        if (currentBranch.equals(targetBranch = BranchManager.normalizeBranch(branchName))) {
            return this;
        }
        Optional<TableSchema> optionalSchema = new SchemaManager(this.fileIO(), this.location(), targetBranch).latest();
        Preconditions.checkArgument(optionalSchema.isPresent(), "Branch " + targetBranch + " does not exist");
        TableSchema branchSchema = optionalSchema.get();
        Options branchOptions = new Options(branchSchema.options());
        branchOptions.set(CoreOptions.BRANCH, targetBranch);
        branchSchema = branchSchema.copy(branchOptions.toMap());
        return FileStoreTableFactory.create(this.fileIO(), this.location(), branchSchema, new Options(), this.catalogEnvironment());
    }

    private RollbackHelper rollbackHelper() {
        return new RollbackHelper(this.snapshotManager(), this.changelogManager(), this.tagManager(), this.fileIO);
    }

    protected RowKindGenerator rowKindGenerator() {
        return RowKindGenerator.create(this.schema(), this.store().options());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileStoreTable that = (AbstractFileStoreTable)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.tableSchema, that.tableSchema);
    }
}

