/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.sort.PartialOrderPriorityQueue;
import org.apache.paimon.utils.MutableObjectIterator;
import org.apache.paimon.utils.Preconditions;

public class BinaryMergeIterator<Entry>
implements MutableObjectIterator<Entry> {
    private final PartialOrderPriorityQueue<HeadStream<Entry>> heap;
    private HeadStream<Entry> currHead;

    public BinaryMergeIterator(List<MutableObjectIterator<Entry>> iterators, List<Entry> reusableEntries, Comparator<Entry> comparator) throws IOException {
        Preconditions.checkArgument(iterators.size() == reusableEntries.size());
        this.heap = new PartialOrderPriorityQueue((o1, o2) -> comparator.compare(o1.getHead(), o2.getHead()), iterators.size());
        for (int i = 0; i < iterators.size(); ++i) {
            this.heap.add(new HeadStream<Entry>(iterators.get(i), reusableEntries.get(i)));
        }
    }

    @Override
    public Entry next(Entry reuse) throws IOException {
        return this.next();
    }

    @Override
    public Entry next() throws IOException {
        if (this.currHead != null) {
            if (this.currHead.noMoreHead()) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
        }
        if (this.heap.size() > 0) {
            this.currHead = this.heap.peek();
            return this.currHead.getHead();
        }
        return null;
    }

    private static final class HeadStream<Entry> {
        private final MutableObjectIterator<Entry> iterator;
        private Entry head;

        private HeadStream(MutableObjectIterator<Entry> iterator, Entry head) throws IOException {
            this.iterator = iterator;
            this.head = head;
            if (this.noMoreHead()) {
                throw new IllegalStateException();
            }
        }

        private Entry getHead() {
            return this.head;
        }

        private boolean noMoreHead() throws IOException {
            this.head = this.iterator.next(this.head);
            return this.head == null;
        }
    }
}

