/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.davidmoten.hilbert;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.paimon.shade.com.github.davidmoten.guavamini.Lists;
import org.apache.paimon.shade.com.github.davidmoten.guavamini.Preconditions;
import org.apache.paimon.shade.org.davidmoten.hilbert.Node;
import org.apache.paimon.shade.org.davidmoten.hilbert.Range;

public class Ranges
implements Iterable<Range> {
    private final int bufferSize;
    private final TreeSet<Node> set;
    private Node ranges;
    private Node last;
    private int count;

    public Ranges(int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 0);
        this.bufferSize = bufferSize;
        this.ranges = null;
        this.set = bufferSize == 0 ? null : new TreeSet();
    }

    public Ranges add(long low, long high) {
        Preconditions.checkArgument(low <= high);
        return this.add(Range.create(low, high));
    }

    public Ranges add(Range r) {
        Preconditions.checkArgument(this.ranges == null || this.ranges.value.high() < r.low(), "ranges must be added in increasing order and without overlap");
        Node node = new Node(r);
        ++this.count;
        if (this.ranges == null) {
            this.ranges = node;
            this.last = node;
        } else if (this.bufferSize == 0) {
            node.setNext(this.ranges);
            this.ranges = node;
        } else {
            node.setNext(this.ranges);
            this.set.add(this.ranges);
            this.ranges = node;
            if (this.count > this.bufferSize) {
                Node first = this.set.pollFirst();
                Range joined = first.value.join(first.previous().value);
                this.set.remove(first.previous());
                Node n = new Node(joined);
                if (first.next() != null) {
                    n.setNext(first.next());
                } else {
                    this.last = n;
                }
                Node firstPrevious = first.previous();
                if (firstPrevious == this.ranges) {
                    this.ranges = n;
                } else {
                    first.previous().previous().setNext(n);
                }
                this.set.add(n);
                first.clearForGc();
                --this.count;
            }
        }
        return this;
    }

    @Override
    public Iterator<Range> iterator() {
        return new Iterator<Range>(){
            Node r;
            {
                this.r = Ranges.this.last;
            }

            @Override
            public boolean hasNext() {
                return this.r != null;
            }

            @Override
            public Range next() {
                Range v = this.r.value;
                this.r = this.r.previous();
                return v;
            }
        };
    }

    public Stream<Range> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public void println() {
        this.forEach(System.out::println);
    }

    public int size() {
        return this.count;
    }

    public List<Range> toList() {
        return Lists.newArrayList(this);
    }

    public String toString() {
        return this.toList().toString();
    }
}

