/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import org.apache.paimon.shade.org.apache.datasketches.memory.Buffer;
import org.apache.paimon.shade.org.apache.datasketches.memory.Memory;
import org.apache.paimon.shade.org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.paimon.shade.org.apache.datasketches.memory.ReadOnlyException;
import org.apache.paimon.shade.org.apache.datasketches.memory.Utf8CodingException;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableBuffer;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableHandle;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMapHandle;
import org.apache.paimon.shade.org.apache.datasketches.memory.WritableMemory;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.AccessByteBuffer;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.AllocateDirect;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.AllocateDirectWritableMap;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BBNonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BBWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseStateImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.CompareAndCopy;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectNonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.HeapNonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.HeapWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Ints;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MapNonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.MapWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Utf8;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Util;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.WritableDirectHandleImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.WritableMapHandleImpl;

public abstract class BaseWritableMemoryImpl
extends BaseStateImpl
implements WritableMemory {
    private static final byte[] EMPTY_BYTES = new byte[1024];

    BaseWritableMemoryImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    public static BaseWritableMemoryImpl wrapHeapArray(Object arr, long offsetBytes, long lengthBytes, boolean localReadOnly, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        int typeId = localReadOnly ? 1 : 0;
        return Util.isNativeByteOrder(byteOrder) ? new HeapWritableMemoryImpl(arr, offsetBytes, lengthBytes, typeId, memReqSvr) : new HeapNonNativeWritableMemoryImpl(arr, offsetBytes, lengthBytes, typeId, memReqSvr);
    }

    public static BaseWritableMemoryImpl wrapByteBuffer(ByteBuffer byteBuf, boolean localReadOnly, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        AccessByteBuffer abb = new AccessByteBuffer(byteBuf);
        int typeId = abb.resourceReadOnly || localReadOnly ? 1 : 0;
        return Util.isNativeByteOrder(byteOrder) ? new BBWritableMemoryImpl(abb.unsafeObj, abb.nativeBaseOffset, abb.regionOffset, abb.capacityBytes, typeId, byteBuf, memReqSvr) : new BBNonNativeWritableMemoryImpl(abb.unsafeObj, abb.nativeBaseOffset, abb.regionOffset, abb.capacityBytes, typeId, byteBuf, memReqSvr);
    }

    public static WritableMapHandle wrapMap(File file, long fileOffsetBytes, long capacityBytes, boolean localReadOnly, ByteOrder byteOrder) {
        AllocateDirectWritableMap dirWMap = new AllocateDirectWritableMap(file, fileOffsetBytes, capacityBytes, localReadOnly);
        int typeId = dirWMap.resourceReadOnly || localReadOnly ? 1 : 0;
        BaseWritableMemoryImpl wmem = Util.isNativeByteOrder(byteOrder) ? new MapWritableMemoryImpl(dirWMap.nativeBaseOffset, 0L, capacityBytes, typeId, dirWMap.getValid()) : new MapNonNativeWritableMemoryImpl(dirWMap.nativeBaseOffset, 0L, capacityBytes, typeId, dirWMap.getValid());
        return new WritableMapHandleImpl(dirWMap, wmem);
    }

    public static WritableHandle wrapDirect(long capacityBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        AllocateDirect direct = new AllocateDirect(capacityBytes);
        boolean typeId = false;
        BaseWritableMemoryImpl wmem = Util.isNativeByteOrder(byteOrder) ? new DirectWritableMemoryImpl(direct.getNativeBaseOffset(), 0L, capacityBytes, 0, direct.getValid(), memReqSvr) : new DirectNonNativeWritableMemoryImpl(direct.getNativeBaseOffset(), 0L, capacityBytes, 0, direct.getValid(), memReqSvr);
        WritableDirectHandleImpl handle = new WritableDirectHandleImpl(direct, wmem);
        return handle;
    }

    @Override
    public Memory region(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        return this.writableRegionImpl(offsetBytes, capacityBytes, true, byteOrder);
    }

    @Override
    public WritableMemory writableRegion(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        return this.writableRegionImpl(offsetBytes, capacityBytes, false, byteOrder);
    }

    WritableMemory writableRegionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly, ByteOrder byteOrder) {
        if (this.isReadOnly() && !localReadOnly) {
            throw new ReadOnlyException("Writable region of a read-only Memory is not allowed.");
        }
        Util.negativeCheck(offsetBytes, "offsetBytes must be >= 0");
        Util.negativeCheck(capacityBytes, "capacityBytes must be >= 0");
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null.");
        this.checkValidAndBounds(offsetBytes, capacityBytes);
        boolean readOnly = this.isReadOnly() || localReadOnly;
        return this.toWritableRegion(offsetBytes, capacityBytes, readOnly, byteOrder);
    }

    abstract BaseWritableMemoryImpl toWritableRegion(long var1, long var3, boolean var5, ByteOrder var6);

    @Override
    public Buffer asBuffer(ByteOrder byteOrder) {
        return this.asWritableBuffer(true, byteOrder);
    }

    @Override
    public WritableBuffer asWritableBuffer(ByteOrder byteOrder) {
        return this.asWritableBuffer(false, byteOrder);
    }

    WritableBuffer asWritableBuffer(boolean localReadOnly, ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        if (this.isReadOnly() && !localReadOnly) {
            throw new ReadOnlyException("Converting a read-only Memory to a writable Buffer is not allowed.");
        }
        boolean readOnly = this.isReadOnly() || localReadOnly;
        BaseWritableBufferImpl wbuf = this.toWritableBuffer(readOnly, byteOrder);
        wbuf.setStartPositionEnd(0L, 0L, this.getCapacity());
        return wbuf;
    }

    abstract BaseWritableBufferImpl toWritableBuffer(boolean var1, ByteOrder var2);

    @Override
    public final boolean getBoolean(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getBoolean(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public final void getBooleanArray(long offsetBytes, boolean[] dstArray, int dstOffsetBooleans, int lengthBooleans) {
        long copyBytes = lengthBooleans;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBooleans, lengthBooleans, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)dstOffsetBooleans, copyBytes);
    }

    @Override
    public final byte getByte(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getByte(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public final void getByteArray(long offsetBytes, byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        long copyBytes = lengthBytes;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBytes, lengthBytes, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)dstOffsetBytes, copyBytes);
    }

    @Override
    public final int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, Appendable dst) throws IOException, Utf8CodingException {
        this.checkValidAndBounds(offsetBytes, utf8LengthBytes);
        return Utf8.getCharsFromUtf8(offsetBytes, utf8LengthBytes, dst, this.getCumulativeOffset(), this.getUnsafeObject());
    }

    @Override
    public final int getCharsFromUtf8(long offsetBytes, int utf8LengthBytes, StringBuilder dst) throws Utf8CodingException {
        try {
            dst.ensureCapacity(dst.length() + utf8LengthBytes);
            return this.getCharsFromUtf8(offsetBytes, utf8LengthBytes, (Appendable)dst);
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    final char getNativeOrderedChar(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getChar(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    final int getNativeOrderedInt(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return UnsafeUtil.unsafe.getInt(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    final long getNativeOrderedLong(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return UnsafeUtil.unsafe.getLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    final short getNativeOrderedShort(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getShort(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public final int compareTo(long thisOffsetBytes, long thisLengthBytes, Memory thatMem, long thatOffsetBytes, long thatLengthBytes) {
        return CompareAndCopy.compare(this, thisOffsetBytes, thisLengthBytes, (BaseStateImpl)((Object)thatMem), thatOffsetBytes, thatLengthBytes);
    }

    @Override
    public final void copyTo(long srcOffsetBytes, WritableMemory destination, long dstOffsetBytes, long lengthBytes) {
        CompareAndCopy.copy(this, srcOffsetBytes, (BaseStateImpl)((Object)destination), dstOffsetBytes, lengthBytes);
    }

    @Override
    public final void writeTo(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        this.checkValidAndBounds(offsetBytes, lengthBytes);
        if (this.getUnsafeObject() instanceof byte[]) {
            this.writeByteArrayTo((byte[])this.getUnsafeObject(), offsetBytes, lengthBytes, out);
        } else if (this.getUnsafeObject() == null) {
            this.writeDirectMemoryTo(offsetBytes, lengthBytes, out);
        } else {
            this.writeToWithExtraCopy(offsetBytes, lengthBytes, out);
        }
    }

    @Override
    public final void putBoolean(long offsetBytes, boolean value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putBoolean(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public final void putBooleanArray(long offsetBytes, boolean[] srcArray, int srcOffsetBooleans, int lengthBooleans) {
        long copyBytes = lengthBooleans;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBooleans, lengthBooleans, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)srcOffsetBooleans, this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public final void putByte(long offsetBytes, byte value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putByte(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public final void putByteArray(long offsetBytes, byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        long copyBytes = lengthBytes;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBytes, lengthBytes, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)srcOffsetBytes, this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public final long putCharsToUtf8(long offsetBytes, CharSequence src) {
        this.checkValid();
        return Utf8.putCharsToUtf8(offsetBytes, src, this.getCapacity(), this.getCumulativeOffset(), this.getUnsafeObject());
    }

    final void putNativeOrderedChar(long offsetBytes, char value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putChar(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    final void putNativeOrderedInt(long offsetBytes, int value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    final void putNativeOrderedLong(long offsetBytes, long value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    final void putNativeOrderedShort(long offsetBytes, short value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putShort(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public final Object getArray() {
        this.assertValid();
        return this.getUnsafeObject();
    }

    @Override
    public final void clear() {
        this.clear(0L, this.getCapacity());
    }

    @Override
    public final void clear(long offsetBytes, long lengthBytes) {
        long endBytes = offsetBytes + lengthBytes;
        for (long i = offsetBytes; i < endBytes; i += (long)EMPTY_BYTES.length) {
            this.putByteArray(i, EMPTY_BYTES, 0, (int)Math.min((long)EMPTY_BYTES.length, endBytes - i));
        }
    }

    @Override
    public final void clearBits(long offsetBytes, byte bitMask) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        long cumBaseOff = this.getCumulativeOffset(offsetBytes);
        int value = UnsafeUtil.unsafe.getByte(this.getUnsafeObject(), cumBaseOff) & 0xFF;
        UnsafeUtil.unsafe.putByte(this.getUnsafeObject(), cumBaseOff, (byte)(value &= ~bitMask));
    }

    @Override
    public final void fill(byte value) {
        this.fill(0L, this.getCapacity(), value);
    }

    @Override
    public final void fill(long offsetBytes, long lengthBytes, byte value) {
        this.checkValidAndBoundsForWrite(offsetBytes, lengthBytes);
        while (lengthBytes > 0L) {
            long chunk = Math.min(lengthBytes, 0x100000L);
            UnsafeUtil.unsafe.setMemory(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), chunk, value);
            offsetBytes += chunk;
            lengthBytes -= chunk;
        }
    }

    @Override
    public final void setBits(long offsetBytes, byte bitMask) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        long myOffset = this.getCumulativeOffset(offsetBytes);
        byte value = UnsafeUtil.unsafe.getByte(this.getUnsafeObject(), myOffset);
        UnsafeUtil.unsafe.putByte(this.getUnsafeObject(), myOffset, (byte)(value | bitMask));
    }

    private void writeByteArrayTo(byte[] unsafeObj, long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        int off = Ints.checkedCast(this.getCumulativeOffset(offsetBytes) - UnsafeUtil.ARRAY_BYTE_BASE_OFFSET);
        int len = Ints.checkedCast(lengthBytes);
        ByteBuffer bufToWrite = ByteBuffer.wrap(unsafeObj, off, len);
        BaseWritableMemoryImpl.writeFully(bufToWrite, out);
    }

    private void writeDirectMemoryTo(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        long addr = this.getCumulativeOffset(offsetBytes);
        while (lengthBytes > 0L) {
            int chunk = (int)Math.min(0x100000L, lengthBytes);
            ByteBuffer bufToWrite = AccessByteBuffer.getDummyReadOnlyDirectByteBuffer(addr, chunk);
            BaseWritableMemoryImpl.writeFully(bufToWrite, out);
            addr += (long)chunk;
            lengthBytes -= (long)chunk;
        }
    }

    private void writeToWithExtraCopy(long offsetBytes, long lengthBytes, WritableByteChannel out) throws IOException {
        int bufLen = Ints.checkedCast(Math.max(8L, Math.min(this.getCapacity() / 1024L & 0xFFFFFFFFFFFFFFF8L, 4096L)));
        byte[] buf = new byte[bufLen];
        ByteBuffer bufToWrite = ByteBuffer.wrap(buf);
        while (lengthBytes > 0L) {
            int chunk = (int)Math.min((long)buf.length, lengthBytes);
            this.getByteArray(offsetBytes, buf, 0, chunk);
            bufToWrite.clear().limit(chunk);
            BaseWritableMemoryImpl.writeFully(bufToWrite, out);
            offsetBytes += (long)chunk;
            lengthBytes -= (long)chunk;
        }
    }

    private static void writeFully(ByteBuffer bufToWrite, WritableByteChannel out) throws IOException {
        while (bufToWrite.remaining() > 0) {
            out.write(bufToWrite);
        }
    }
}

