/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.hc.client5.http.impl.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.paimon.shade.hc.client5.http.auth.AuthChallenge;
import org.apache.paimon.shade.hc.client5.http.auth.AuthScheme;
import org.apache.paimon.shade.hc.client5.http.auth.AuthScope;
import org.apache.paimon.shade.hc.client5.http.auth.AuthStateCacheable;
import org.apache.paimon.shade.hc.client5.http.auth.AuthenticationException;
import org.apache.paimon.shade.hc.client5.http.auth.BearerToken;
import org.apache.paimon.shade.hc.client5.http.auth.Credentials;
import org.apache.paimon.shade.hc.client5.http.auth.CredentialsProvider;
import org.apache.paimon.shade.hc.client5.http.auth.MalformedChallengeException;
import org.apache.paimon.shade.hc.client5.http.impl.StateHolder;
import org.apache.paimon.shade.hc.client5.http.protocol.HttpClientContext;
import org.apache.paimon.shade.hc.core5.annotation.Internal;
import org.apache.paimon.shade.hc.core5.http.HttpHost;
import org.apache.paimon.shade.hc.core5.http.HttpRequest;
import org.apache.paimon.shade.hc.core5.http.NameValuePair;
import org.apache.paimon.shade.hc.core5.http.protocol.HttpContext;
import org.apache.paimon.shade.hc.core5.util.Args;
import org.apache.paimon.shade.hc.core5.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthStateCacheable
public class BearerScheme
implements AuthScheme,
StateHolder<State>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(BearerScheme.class);
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private boolean complete = false;
    private BearerToken bearerToken;

    @Override
    public String getName() {
        return "Bearer";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getRealm() {
        return this.paramMap.get("realm");
    }

    @Override
    public void processChallenge(AuthChallenge authChallenge, HttpContext context) throws MalformedChallengeException {
        this.paramMap.clear();
        List<NameValuePair> params = authChallenge.getParams();
        if (params != null) {
            String error;
            for (NameValuePair param : params) {
                this.paramMap.put(param.getName().toLowerCase(Locale.ROOT), param.getValue());
            }
            if (LOG.isDebugEnabled() && (error = this.paramMap.get("error")) != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(error);
                String desc = this.paramMap.get("error_description");
                String uri = this.paramMap.get("error_uri");
                if (desc != null || uri != null) {
                    buf.append(" (");
                    buf.append(desc).append("; ").append(uri);
                    buf.append(")");
                }
                LOG.debug(buf.toString());
            }
        }
        this.complete = true;
    }

    @Override
    public boolean isChallengeComplete() {
        return this.complete;
    }

    @Override
    public boolean isResponseReady(HttpHost host, CredentialsProvider credentialsProvider, HttpContext context) throws AuthenticationException {
        Args.notNull(host, "Auth host");
        Args.notNull(credentialsProvider, "Credentials provider");
        AuthScope authScope = new AuthScope(host, this.getRealm(), this.getName());
        Credentials credentials = credentialsProvider.getCredentials(authScope, context);
        if (credentials instanceof BearerToken) {
            this.bearerToken = (BearerToken)credentials;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            HttpClientContext clientContext = HttpClientContext.cast(context);
            String exchangeId = clientContext.getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", (Object)exchangeId, (Object)authScope);
        }
        this.bearerToken = null;
        return false;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public String generateAuthResponse(HttpHost host, HttpRequest request, HttpContext context) throws AuthenticationException {
        Asserts.notNull(this.bearerToken, "Bearer token");
        return "Bearer " + this.bearerToken.getToken();
    }

    @Override
    public State store() {
        if (this.complete) {
            return new State(new HashMap<String, String>(this.paramMap), this.bearerToken);
        }
        return null;
    }

    @Override
    public void restore(State state) {
        if (state != null) {
            this.paramMap.clear();
            this.paramMap.putAll(state.params);
            this.bearerToken = state.bearerToken;
            this.complete = true;
        }
    }

    public String toString() {
        return this.getName() + this.paramMap;
    }

    @Internal
    public static class State {
        final Map<String, String> params;
        final BearerToken bearerToken;

        State(Map<String, String> params, BearerToken bearerToken) {
            this.params = params;
            this.bearerToken = bearerToken;
        }

        public String toString() {
            return "State{params=" + this.params + ", bearerToken=" + this.bearerToken + '}';
        }
    }
}

