/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.network.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.paimon.service.network.stats.ServiceRequestStats;

public class AtomicServiceRequestStats
implements ServiceRequestStats {
    private final AtomicLong numConnections = new AtomicLong();
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong numSuccessful = new AtomicLong();
    private final AtomicLong successfulDuration = new AtomicLong();
    private final AtomicLong numFailed = new AtomicLong();

    @Override
    public void reportActiveConnection() {
        this.numConnections.incrementAndGet();
    }

    @Override
    public void reportInactiveConnection() {
        this.numConnections.decrementAndGet();
    }

    @Override
    public void reportRequest() {
        this.numRequests.incrementAndGet();
    }

    @Override
    public void reportSuccessfulRequest(long durationTotalMillis) {
        this.numSuccessful.incrementAndGet();
        this.successfulDuration.addAndGet(durationTotalMillis);
    }

    @Override
    public void reportFailedRequest() {
        this.numFailed.incrementAndGet();
    }

    public long getNumConnections() {
        return this.numConnections.get();
    }

    public long getNumRequests() {
        return this.numRequests.get();
    }

    public long getNumSuccessful() {
        return this.numSuccessful.get();
    }

    public long getNumFailed() {
        return this.numFailed.get();
    }

    public String toString() {
        return "AtomicServiceRequestStats{numConnections=" + this.numConnections + ", numRequests=" + this.numRequests + ", numSuccessful=" + this.numSuccessful + ", numFailed=" + this.numFailed + "}";
    }
}

