/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.network;

import java.nio.channels.ClosedChannelException;
import org.apache.paimon.service.network.ClientHandlerCallback;
import org.apache.paimon.service.network.messages.MessageBody;
import org.apache.paimon.service.network.messages.MessageSerializer;
import org.apache.paimon.service.network.messages.MessageType;
import org.apache.paimon.service.network.messages.RequestFailure;
import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBuf;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.paimon.shade.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandler<REQ extends MessageBody, RESP extends MessageBody>
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHandler.class);
    private final MessageSerializer<REQ, RESP> serializer;
    private final ClientHandlerCallback<RESP> callback;

    public ClientHandler(MessageSerializer<REQ, RESP> serializer, ClientHandlerCallback<RESP> callback) {
        this.serializer = Preconditions.checkNotNull(serializer);
        this.callback = Preconditions.checkNotNull(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block10: {
            try {
                ByteBuf buf = (ByteBuf)msg;
                MessageType msgType = MessageSerializer.deserializeHeader(buf);
                if (msgType == MessageType.REQUEST_RESULT) {
                    long requestId = MessageSerializer.getRequestId(buf);
                    RESP result = this.serializer.deserializeResponse(buf);
                    this.callback.onRequestResult(requestId, result);
                    break block10;
                }
                if (msgType == MessageType.REQUEST_FAILURE) {
                    RequestFailure failure = MessageSerializer.deserializeRequestFailure(buf);
                    this.callback.onRequestFailure(failure.getRequestId(), failure.getCause());
                    break block10;
                }
                if (msgType == MessageType.SERVER_FAILURE) {
                    throw MessageSerializer.deserializeServerFailure(buf);
                }
                throw new IllegalStateException("Unexpected response type '" + msgType + "'");
            }
            catch (Throwable t1) {
                try {
                    this.callback.onFailure(t1);
                }
                catch (Throwable t2) {
                    LOG.error("Failed to notify callback about failure", t2);
                }
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            this.callback.onFailure(cause);
        }
        catch (Throwable t) {
            LOG.error("Failed to notify callback about failure", t);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        try {
            this.callback.onFailure(new ClosedChannelException());
        }
        catch (Throwable t) {
            LOG.error("Failed to notify callback about failure", t);
        }
    }
}

