/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.security;

import java.io.File;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class SecurityConfiguration {
    public static final ConfigOption<String> KERBEROS_LOGIN_KEYTAB = ConfigOptions.key("security.kerberos.login.keytab").stringType().noDefaultValue().withFallbackKeys("security.keytab").withDescription("Absolute path to a Kerberos keytab file that contains the user credentials.");
    public static final ConfigOption<String> KERBEROS_LOGIN_PRINCIPAL = ConfigOptions.key("security.kerberos.login.principal").stringType().noDefaultValue().withFallbackKeys("security.principal").withDescription("Kerberos principal name associated with the keytab.");
    public static final ConfigOption<Boolean> KERBEROS_LOGIN_USETICKETCACHE = ConfigOptions.key("security.kerberos.login.use-ticket-cache").booleanType().defaultValue(true).withDescription("Indicates whether to read from your Kerberos ticket cache.");
    private final Options options;
    private final boolean useTicketCache;
    private final String keytab;
    private final String principal;

    public SecurityConfiguration(Options options) {
        this.options = Preconditions.checkNotNull(options);
        this.keytab = options.get(KERBEROS_LOGIN_KEYTAB);
        this.principal = options.get(KERBEROS_LOGIN_PRINCIPAL);
        this.useTicketCache = options.get(KERBEROS_LOGIN_USETICKETCACHE);
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean useTicketCache() {
        return this.useTicketCache;
    }

    public Options getOptions() {
        return this.options;
    }

    public boolean isLegal() {
        if (StringUtils.isNullOrWhitespaceOnly(this.keytab) != StringUtils.isNullOrWhitespaceOnly(this.principal)) {
            return false;
        }
        if (!StringUtils.isNullOrWhitespaceOnly(this.keytab)) {
            File keytabFile = new File(this.keytab);
            return keytabFile.exists() && keytabFile.isFile() && keytabFile.canRead();
        }
        return true;
    }
}

