/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.ReassignFieldId;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
@Public
public class Schema {
    private static final String FIELD_FIELDS = "fields";
    private static final String FIELD_PARTITION_KEYS = "partitionKeys";
    private static final String FIELD_PRIMARY_KEYS = "primaryKeys";
    private static final String FIELD_OPTIONS = "options";
    private static final String FIELD_COMMENT = "comment";
    @JsonProperty(value="fields")
    private final List<DataField> fields;
    @JsonProperty(value="partitionKeys")
    private final List<String> partitionKeys;
    @JsonProperty(value="primaryKeys")
    private final List<String> primaryKeys;
    @JsonProperty(value="options")
    private final Map<String, String> options;
    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String comment;

    @JsonCreator
    public Schema(@JsonProperty(value="fields") List<DataField> fields, @JsonProperty(value="partitionKeys") List<String> partitionKeys, @JsonProperty(value="primaryKeys") List<String> primaryKeys, @JsonProperty(value="options") Map<String, String> options, @Nullable @JsonProperty(value="comment") String comment) {
        this.options = new HashMap<String, String>(options);
        this.partitionKeys = this.normalizePartitionKeys(partitionKeys);
        this.primaryKeys = this.normalizePrimaryKeys(primaryKeys);
        this.fields = Schema.normalizeFields(fields, this.primaryKeys, this.partitionKeys);
        this.comment = comment;
    }

    public RowType rowType() {
        return new RowType(false, this.fields);
    }

    @JsonGetter(value="fields")
    public List<DataField> fields() {
        return this.fields;
    }

    @JsonGetter(value="partitionKeys")
    public List<String> partitionKeys() {
        return this.partitionKeys;
    }

    @JsonGetter(value="primaryKeys")
    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    @JsonGetter(value="options")
    public Map<String, String> options() {
        return this.options;
    }

    @JsonGetter(value="comment")
    public String comment() {
        return this.comment;
    }

    public Schema copy(RowType rowType) {
        return new Schema(rowType.getFields(), this.partitionKeys, this.primaryKeys, this.options, this.comment);
    }

    private static List<DataField> normalizeFields(List<DataField> fields, List<String> primaryKeys, List<String> partitionKeys) {
        List<String> fieldNames = fields.stream().map(DataField::name).collect(Collectors.toList());
        Set<String> duplicateColumns = Schema.duplicateFields(fieldNames);
        Preconditions.checkState(duplicateColumns.isEmpty(), "Table column %s must not contain duplicate fields. Found: %s", fieldNames, duplicateColumns);
        HashSet<String> allFields = new HashSet<String>(fieldNames);
        duplicateColumns = Schema.duplicateFields(partitionKeys);
        Preconditions.checkState(duplicateColumns.isEmpty(), "Partition key constraint %s must not contain duplicate columns. Found: %s", partitionKeys, duplicateColumns);
        Preconditions.checkState(allFields.containsAll(partitionKeys), "Table column %s should include all partition fields %s", fieldNames, partitionKeys);
        if (primaryKeys.isEmpty()) {
            return fields;
        }
        duplicateColumns = Schema.duplicateFields(primaryKeys);
        Preconditions.checkState(duplicateColumns.isEmpty(), "Primary key constraint %s must not contain duplicate columns. Found: %s", primaryKeys, duplicateColumns);
        Preconditions.checkState(allFields.containsAll(primaryKeys), "Table column %s should include all primary key constraint %s", fieldNames, primaryKeys);
        HashSet<String> pkSet = new HashSet<String>(primaryKeys);
        ArrayList<DataField> newFields = new ArrayList<DataField>();
        for (DataField field : fields) {
            if (pkSet.contains(field.name()) && field.type().isNullable()) {
                newFields.add(new DataField(field.id(), field.name(), field.type().copy(false), field.description(), field.defaultValue()));
                continue;
            }
            newFields.add(field);
        }
        return newFields;
    }

    private List<String> normalizePrimaryKeys(List<String> primaryKeys) {
        if (this.options.containsKey(CoreOptions.PRIMARY_KEY.key())) {
            if (!primaryKeys.isEmpty()) {
                throw new RuntimeException("Cannot define primary key on DDL and table options at the same time.");
            }
            String pk = this.options.get(CoreOptions.PRIMARY_KEY.key());
            primaryKeys = Arrays.stream(pk.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            this.options.remove(CoreOptions.PRIMARY_KEY.key());
        }
        return primaryKeys;
    }

    private List<String> normalizePartitionKeys(List<String> partitionKeys) {
        if (this.options.containsKey(CoreOptions.PARTITION.key())) {
            if (!partitionKeys.isEmpty()) {
                throw new RuntimeException("Cannot define partition on DDL and table options at the same time.");
            }
            String partitions = this.options.get(CoreOptions.PARTITION.key());
            partitionKeys = Arrays.stream(partitions.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            this.options.remove(CoreOptions.PARTITION.key());
        }
        return partitionKeys;
    }

    public static Set<String> duplicateFields(List<String> names) {
        return names.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema that = (Schema)o;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.primaryKeys, that.primaryKeys) && Objects.equals(this.options, that.options) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.partitionKeys, this.primaryKeys, this.options, this.comment);
    }

    public String toString() {
        return "UpdateSchema{fields=" + this.fields + ", partitionKeys=" + this.partitionKeys + ", primaryKeys=" + this.primaryKeys + ", options=" + this.options + ", comment=" + this.comment + "}";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<DataField> columns = new ArrayList<DataField>();
        private List<String> partitionKeys = new ArrayList<String>();
        private List<String> primaryKeys = new ArrayList<String>();
        private final Map<String, String> options = new HashMap<String, String>();
        @Nullable
        private String comment;
        private final AtomicInteger highestFieldId = new AtomicInteger(-1);

        public int getHighestFieldId() {
            return this.highestFieldId.get();
        }

        public Builder column(String columnName, DataType dataType) {
            return this.column(columnName, dataType, null);
        }

        public Builder column(String columnName, DataType dataType, @Nullable String description) {
            return this.column(columnName, dataType, description, null);
        }

        public Builder column(String columnName, DataType dataType, @Nullable String description, @Nullable String defaultValue) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(dataType, "Data type must not be null.");
            int id = this.highestFieldId.incrementAndGet();
            DataType reassignDataType = ReassignFieldId.reassign(dataType, this.highestFieldId);
            this.columns.add(new DataField(id, columnName, reassignDataType, description, defaultValue));
            return this;
        }

        public Builder partitionKeys(String ... columnNames) {
            return this.partitionKeys(Arrays.asList(columnNames));
        }

        public Builder partitionKeys(List<String> columnNames) {
            this.partitionKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder primaryKey(String ... columnNames) {
            return this.primaryKey(Arrays.asList(columnNames));
        }

        public Builder primaryKey(List<String> columnNames) {
            this.primaryKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Schema build() {
            return new Schema(this.columns, this.partitionKeys, this.primaryKeys, this.options, this.comment);
        }
    }
}

