/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.SimpleHttpClient;
import org.apache.paimon.rest.auth.DLFToken;
import org.apache.paimon.rest.auth.DLFTokenLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLFECSTokenLoader
implements DLFTokenLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DLFECSTokenLoader.class);
    private final String ecsMetadataURL;
    private String roleName;

    public DLFECSTokenLoader(String ecsMetaDataURL, @Nullable String roleName) {
        this.ecsMetadataURL = ecsMetaDataURL;
        this.roleName = roleName;
    }

    @Override
    public DLFToken loadToken() {
        if (this.roleName == null) {
            this.roleName = DLFECSTokenLoader.getRole(this.ecsMetadataURL);
        }
        return DLFECSTokenLoader.getToken(this.ecsMetadataURL + this.roleName);
    }

    @Override
    public String description() {
        return this.ecsMetadataURL;
    }

    private static String getRole(String url) {
        try {
            return DLFECSTokenLoader.getResponseBody(url);
        }
        catch (Exception e) {
            throw new RuntimeException("get role failed, error : " + e.getMessage(), e);
        }
    }

    private static DLFToken getToken(String url) {
        try {
            String token = SimpleHttpClient.INSTANCE.get(url);
            return RESTApi.fromJson(token, DLFToken.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException("get token failed, error : " + e.getMessage(), e);
        }
    }

    @VisibleForTesting
    protected static String getResponseBody(String url) {
        long startTime = System.currentTimeMillis();
        try {
            String responseBodyStr = SimpleHttpClient.INSTANCE.get(url);
            if (LOG.isDebugEnabled()) {
                LOG.debug("get response success, url : {}, cost : {} ms", (Object)url, (Object)(System.currentTimeMillis() - startTime));
            }
            return responseBodyStr;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("get response failed, error : " + e.getMessage(), e);
        }
    }
}

