/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.paimon.rest.HttpClientUtils;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpGet;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpPost;
import org.apache.paimon.shade.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.paimon.shade.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.paimon.shade.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.paimon.shade.hc.core5.http.Header;
import org.apache.paimon.shade.hc.core5.http.ParseException;
import org.apache.paimon.shade.hc.core5.http.io.entity.StringEntity;
import org.apache.paimon.shade.hc.core5.http.message.BasicHeader;
import org.apache.paimon.utils.StringUtils;

public class SimpleHttpClient
implements Closeable {
    public static final SimpleHttpClient INSTANCE = new SimpleHttpClient();
    private final CloseableHttpClient client = HttpClientUtils.createBuilder().build();

    private SimpleHttpClient() {
    }

    public String post(String url, Object body, Map<String, String> headers) throws IOException {
        String encodedBody;
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            httpPost.setHeaders((Header[])headers.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), entry.getValue())).toArray(Header[]::new));
        }
        if ((encodedBody = RESTUtil.encodedBody(body)) != null) {
            httpPost.setEntity(new StringEntity(encodedBody));
        }
        return this.exec(httpPost);
    }

    public String get(String url, Map<String, String> queryParams, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(RESTUtil.buildRequestUrl(url, queryParams));
        if (headers != null) {
            httpGet.setHeaders((Header[])headers.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), entry.getValue())).toArray(Header[]::new));
        }
        return this.exec(httpGet);
    }

    public String get(String url) throws IOException {
        return this.get(url, null, null);
    }

    private String exec(HttpUriRequestBase request) {
        String string;
        block9: {
            CloseableHttpResponse response = this.client.execute(request);
            try {
                String responseBodyStr = RESTUtil.extractResponseBodyAsString(response);
                if (StringUtils.isNullOrWhitespaceOnly(responseBodyStr) || !RESTUtil.isSuccessful(response)) {
                    throw new RuntimeException(RESTUtil.isSuccessful(response) ? "ResponseBody is null or empty." : String.format("Response is not successful, response is %s", response));
                }
                string = responseBodyStr;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException("Failed to convert HTTP response body to string, error : " + e.getMessage());
                }
            }
            response.close();
        }
        return string;
    }

    @Override
    public void close() throws IOException {
        try {
            this.client.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

