/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.reader;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.reader.DataEvolutionRow;
import org.apache.paimon.reader.RecordReader;

public class DataEvolutionIterator
implements RecordReader.RecordIterator<InternalRow> {
    private final DataEvolutionRow row;
    private final RecordReader.RecordIterator<InternalRow>[] iterators;

    public DataEvolutionIterator(DataEvolutionRow row, RecordReader.RecordIterator<InternalRow>[] iterators) {
        this.row = row;
        this.iterators = iterators;
    }

    @Override
    @Nullable
    public InternalRow next() throws IOException {
        for (int i = 0; i < this.iterators.length; ++i) {
            if (this.iterators[i] == null) continue;
            InternalRow next = this.iterators[i].next();
            if (next == null) {
                return null;
            }
            this.row.setRow(i, next);
        }
        return this.row;
    }

    @Override
    public void releaseBatch() {
        for (RecordReader.RecordIterator<InternalRow> iterator : this.iterators) {
            if (iterator == null) continue;
            iterator.releaseBatch();
        }
    }
}

