/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.append.BucketedAppendCompactManager;
import org.apache.paimon.compact.CompactManager;
import org.apache.paimon.compact.NoopCompactManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.BaseAppendFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SnapshotManager;

public class BucketedAppendFileStoreWrite
extends BaseAppendFileStoreWrite {
    private final String commitUser;

    public BucketedAppendFileStoreWrite(FileIO fileIO, RawFileSplitRead read, long schemaId, String commitUser, RowType rowType, RowType partitionType, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options, @Nullable BucketedDvMaintainer.Factory dvMaintainerFactory, String tableName) {
        super(fileIO, read, schemaId, rowType, partitionType, pathFactory, snapshotManager, scan, options, dvMaintainerFactory, tableName);
        this.commitUser = commitUser;
    }

    @Override
    protected CompactManager getCompactManager(BinaryRow partition, int bucket, List<DataFileMeta> restoredFiles, ExecutorService compactExecutor, @Nullable BucketedDvMaintainer dvMaintainer) {
        if (this.options.writeOnly()) {
            return new NoopCompactManager();
        }
        Function<String, DeletionVector> dvFactory = dvMaintainer != null ? f -> dvMaintainer.deletionVectorOf((String)f).orElse(null) : null;
        return new BucketedAppendCompactManager(compactExecutor, restoredFiles, dvMaintainer, this.options.compactionMinFileNum(), this.options.targetFileSize(false), this.options.forceRewriteAllFiles(), files -> this.compactRewrite(partition, bucket, dvFactory, files), this.compactionMetrics == null ? null : this.compactionMetrics.createReporter(partition, bucket));
    }

    @Override
    protected Function<AbstractFileStoreWrite.WriterContainer<InternalRow>, Boolean> createWriterCleanChecker() {
        return BucketedAppendFileStoreWrite.createConflictAwareWriterCleanChecker(this.commitUser, this.restore);
    }
}

