/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.BucketSelectConverter;
import org.apache.paimon.operation.ManifestsReader;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class AppendOnlyFileStoreScan
extends AbstractFileStoreScan {
    private final BucketSelectConverter bucketSelectConverter;
    private final SimpleStatsEvolutions simpleStatsEvolutions;
    private final boolean fileIndexReadEnabled;
    private Predicate inputFilter;
    private final Map<Long, Predicate> notEvolvedFilterMapping = new ConcurrentHashMap<Long, Predicate>();
    private final Map<Long, Predicate> evolvedFilterMapping = new ConcurrentHashMap<Long, Predicate>();

    public AppendOnlyFileStoreScan(ManifestsReader manifestsReader, BucketSelectConverter bucketSelectConverter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, ManifestFile.Factory manifestFileFactory, Integer scanManifestParallelism, boolean fileIndexReadEnabled) {
        super(manifestsReader, snapshotManager, schemaManager, schema, manifestFileFactory, scanManifestParallelism);
        this.bucketSelectConverter = bucketSelectConverter;
        this.simpleStatsEvolutions = new SimpleStatsEvolutions(sid -> this.scanTableSchema((long)sid).fields(), schema.id());
        this.fileIndexReadEnabled = fileIndexReadEnabled;
    }

    public AppendOnlyFileStoreScan withFilter(Predicate predicate) {
        this.inputFilter = predicate;
        this.bucketSelectConverter.convert(predicate).ifPresent(this::withTotalAwareBucketFilter);
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        Predicate notEvolvedFilter = this.notEvolvedFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.simpleStatsEvolutions.filterUnsafeFilter(entry.file().schemaId(), this.inputFilter, true));
        if (notEvolvedFilter == null) {
            return true;
        }
        SimpleStatsEvolution evolution = this.simpleStatsEvolutions.getOrCreate(entry.file().schemaId());
        SimpleStatsEvolution.Result stats = evolution.evolution(entry.file().valueStats(), (Long)entry.file().rowCount(), entry.file().valueStatsCols());
        boolean result = notEvolvedFilter.test(entry.file().rowCount(), stats.minValues(), stats.maxValues(), stats.nullCounts());
        if (!result) {
            return false;
        }
        if (!this.fileIndexReadEnabled) {
            return true;
        }
        return this.testFileIndex(entry.file().embeddedIndex(), entry);
    }

    private boolean testFileIndex(@Nullable byte[] embeddedIndexBytes, ManifestEntry entry) {
        boolean bl;
        if (embeddedIndexBytes == null) {
            return true;
        }
        RowType dataRowType = this.scanTableSchema(entry.file().schemaId()).logicalRowType();
        Predicate dataPredicate = this.evolvedFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.simpleStatsEvolutions.tryDevolveFilter(entry.file().schemaId(), this.inputFilter));
        FileIndexPredicate predicate = new FileIndexPredicate(embeddedIndexBytes, dataRowType);
        try {
            bl = predicate.evaluate(dataPredicate).remain();
        }
        catch (Throwable throwable) {
            try {
                try {
                    predicate.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Exception happens while checking predicate.", e);
            }
        }
        predicate.close();
        return bl;
    }
}

