/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metastore;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.shade.guava30.com.google.common.cache.Cache;
import org.apache.paimon.shade.guava30.com.google.common.cache.CacheBuilder;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.utils.InternalRowPartitionComputer;

public class AddPartitionCommitCallback
implements CommitCallback {
    private final Cache<BinaryRow, Boolean> cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).maximumSize(300L).softValues().build();
    private final PartitionHandler partitionHandler;
    private final InternalRowPartitionComputer partitionComputer;

    public AddPartitionCommitCallback(PartitionHandler partitionHandler, InternalRowPartitionComputer partitionComputer) {
        this.partitionHandler = partitionHandler;
        this.partitionComputer = partitionComputer;
    }

    @Override
    public void call(List<SimpleFileEntry> baseFiles, List<ManifestEntry> deltaFiles, List<IndexManifestEntry> indexFiles, Snapshot snapshot) {
        Set<BinaryRow> partitions = deltaFiles.stream().filter(e -> FileKind.ADD.equals((Object)e.kind())).map(FileEntry::partition).collect(Collectors.toSet());
        this.addPartitions(partitions);
    }

    @Override
    public void retry(ManifestCommittable committable) {
        Set<BinaryRow> partitions = committable.fileCommittables().stream().map(CommitMessage::partition).collect(Collectors.toSet());
        this.addPartitions(partitions);
    }

    private void addPartitions(Set<BinaryRow> partitions) {
        try {
            ArrayList<BinaryRow> newPartitions = new ArrayList<BinaryRow>();
            for (BinaryRow partition2 : partitions) {
                if (this.cache.get(partition2, () -> false).booleanValue()) continue;
                newPartitions.add(partition2);
            }
            if (!newPartitions.isEmpty()) {
                this.partitionHandler.createPartitions(newPartitions.stream().map(this.partitionComputer::generatePartValues).collect(Collectors.toList()));
                newPartitions.forEach(partition -> this.cache.put((BinaryRow)partition, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.partitionHandler.close();
    }
}

