/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate.factory;

import org.apache.paimon.CoreOptions;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.mergetree.compact.aggregate.FieldIgnoreRetractAgg;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;

public interface FieldAggregatorFactory
extends Factory {
    public FieldAggregator create(DataType var1, CoreOptions var2, String var3);

    @Override
    public String identifier();

    public static FieldAggregator create(DataType fieldType, String fieldName, String aggFuncName, CoreOptions options) {
        FieldAggregatorFactory fieldAggregatorFactory = FactoryUtil.discoverFactory(FieldAggregator.class.getClassLoader(), FieldAggregatorFactory.class, aggFuncName);
        if (fieldAggregatorFactory == null) {
            throw new RuntimeException(String.format("Use unsupported aggregation: %s or spell aggregate function incorrectly!", aggFuncName));
        }
        boolean removeRecordOnRetract = options.aggregationRemoveRecordOnDelete();
        boolean fieldIgnoreRetract = options.fieldAggIgnoreRetract(fieldName);
        Preconditions.checkState(!removeRecordOnRetract || !fieldIgnoreRetract, String.format("%s and %s have conflicting behavior so should not be enabled at the same time.", CoreOptions.AGGREGATION_REMOVE_RECORD_ON_DELETE, "fields." + fieldName + ".ignore-retract"));
        FieldAggregator fieldAggregator = fieldAggregatorFactory.create(fieldType, options, fieldName);
        return fieldIgnoreRetract ? new FieldIgnoreRetractAgg(fieldAggregator) : fieldAggregator;
    }
}

