/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.utils.RoaringBitmap32;

public class FieldRoaringBitmap32Agg
extends FieldAggregator {
    private static final long serialVersionUID = 1L;
    private final RoaringBitmap32 roaringBitmapAcc = new RoaringBitmap32();
    private final RoaringBitmap32 roaringBitmapInput = new RoaringBitmap32();

    public FieldRoaringBitmap32Agg(String name, VarBinaryType dataType) {
        super(name, dataType);
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        if (accumulator == null || inputField == null) {
            return accumulator == null ? inputField : accumulator;
        }
        try {
            this.roaringBitmapAcc.deserialize(ByteBuffer.wrap((byte[])accumulator));
            this.roaringBitmapInput.deserialize(ByteBuffer.wrap((byte[])inputField));
            this.roaringBitmapAcc.or(this.roaringBitmapInput);
            byte[] byArray = this.roaringBitmapAcc.serialize();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to se/deserialize roaring bitmap.", e);
        }
        finally {
            this.roaringBitmapAcc.clear();
            this.roaringBitmapInput.clear();
        }
    }
}

