/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.mergetree.compact.FirstRowMergeFunction;
import org.apache.paimon.mergetree.compact.KeyValueBuffer;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;

public class LookupMergeFunction
implements MergeFunction<KeyValue> {
    private final MergeFunction<KeyValue> mergeFunction;
    private final KeyValueBuffer candidates;
    private boolean containLevel0;
    private InternalRow currentKey;

    public LookupMergeFunction(MergeFunction<KeyValue> mergeFunction, CoreOptions options, RowType keyType, RowType valueType, @Nullable IOManager ioManager) {
        this.mergeFunction = mergeFunction;
        this.candidates = KeyValueBuffer.createHybridBuffer(options, keyType, valueType, ioManager);
    }

    @Override
    public void reset() {
        this.candidates.reset();
        this.currentKey = null;
        this.containLevel0 = false;
    }

    @Override
    public void add(KeyValue kv) {
        this.currentKey = kv.key();
        if (kv.level() == 0) {
            this.containLevel0 = true;
        }
        this.candidates.put(kv);
    }

    public boolean containLevel0() {
        return this.containLevel0;
    }

    @Nullable
    public KeyValue pickHighLevel() {
        KeyValue highLevel = null;
        try (CloseableIterator<KeyValue> iterator = this.candidates.iterator();){
            while (iterator.hasNext()) {
                KeyValue kv = (KeyValue)iterator.next();
                if (kv.level() <= 0 || highLevel != null && kv.level() >= highLevel.level()) continue;
                highLevel = kv;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return highLevel;
    }

    public InternalRow key() {
        return this.currentKey;
    }

    public void insertInto(KeyValue highLevel, Comparator<KeyValue> comparator) {
        KeyValueBuffer.insertInto(this.candidates, highLevel, comparator);
    }

    @Override
    public KeyValue getResult() {
        this.mergeFunction.reset();
        KeyValue highLevel = this.pickHighLevel();
        try (CloseableIterator<KeyValue> iterator = this.candidates.iterator();){
            while (iterator.hasNext()) {
                KeyValue kv = (KeyValue)iterator.next();
                if (kv.level() > 0 && kv != highLevel) continue;
                this.mergeFunction.add(kv);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.mergeFunction.getResult();
    }

    @Override
    public boolean requireCopy() {
        return true;
    }

    public static MergeFunctionFactory<KeyValue> wrap(MergeFunctionFactory<KeyValue> wrapped, CoreOptions options, RowType keyType, RowType valueType) {
        if (wrapped.create() instanceof FirstRowMergeFunction) {
            return wrapped;
        }
        return new Factory(wrapped, options, keyType, valueType);
    }

    public static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final MergeFunctionFactory<KeyValue> wrapped;
        private final CoreOptions options;
        private final RowType keyType;
        private final RowType valueType;
        @Nullable
        private IOManager ioManager;

        private Factory(MergeFunctionFactory<KeyValue> wrapped, CoreOptions options, RowType keyType, RowType valueType) {
            this.wrapped = wrapped;
            this.options = options;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public void withIOManager(@Nullable IOManager ioManager) {
            this.ioManager = ioManager;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new LookupMergeFunction(this.wrapped.create(projection), this.options, this.keyType, this.valueType, this.ioManager);
        }

        @Override
        public MergeFunctionFactory.AdjustedProjection adjustProjection(@Nullable int[][] projection) {
            return this.wrapped.adjustProjection(projection);
        }
    }
}

