/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.disk.ExternalBuffer;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.InMemoryBuffer;
import org.apache.paimon.disk.RowBuffer;
import org.apache.paimon.memory.HeapMemorySegmentPool;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.memory.UnlimitedSegmentPool;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.KeyValueWithLevelNoReusingSerializer;
import org.apache.paimon.utils.LazyField;

public interface KeyValueBuffer {
    public void reset();

    public void put(KeyValue var1);

    public CloseableIterator<KeyValue> iterator();

    public static BinaryBuffer createBinaryBuffer(CoreOptions options, RowType keyType, RowType valueType, @Nullable IOManager ioManager) {
        KeyValueWithLevelNoReusingSerializer kvSerializer = new KeyValueWithLevelNoReusingSerializer(keyType, valueType);
        MemorySegmentPool pool = ioManager == null ? new UnlimitedSegmentPool(options.pageSize()) : new HeapMemorySegmentPool(options.lookupMergeBufferSize(), options.pageSize());
        InternalRowSerializer serializer = new InternalRowSerializer(kvSerializer.fieldTypes());
        RowBuffer buffer = ioManager == null ? new InMemoryBuffer(pool, serializer) : new ExternalBuffer(ioManager, pool, serializer, options.writeBufferSpillDiskSize(), options.spillCompressOptions());
        return new BinaryBuffer(buffer, kvSerializer);
    }

    public static HybridBuffer createHybridBuffer(CoreOptions options, RowType keyType, RowType valueType, @Nullable IOManager ioManager) {
        Supplier<BinaryBuffer> binarySupplier = () -> KeyValueBuffer.createBinaryBuffer(options, keyType, valueType, ioManager);
        int threshold = options == null ? 1024 : options.lookupMergeRecordsThreshold();
        return new HybridBuffer(threshold, new LazyField<BinaryBuffer>(binarySupplier));
    }

    public static void insertInto(KeyValueBuffer buffer, KeyValue highLevel, Comparator<KeyValue> comparator) {
        ArrayList<KeyValue> newCandidates = new ArrayList<KeyValue>();
        try (CloseableIterator<KeyValue> iterator = buffer.iterator();){
            while (iterator.hasNext()) {
                KeyValue candidate = (KeyValue)iterator.next();
                if (highLevel != null && comparator.compare(highLevel, candidate) < 0) {
                    newCandidates.add(highLevel);
                    newCandidates.add(candidate);
                    highLevel = null;
                    continue;
                }
                newCandidates.add(candidate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (highLevel != null) {
            newCandidates.add(highLevel);
        }
        buffer.reset();
        for (KeyValue kv : newCandidates) {
            buffer.put(kv);
        }
    }

    public static class BinaryBuffer
    implements KeyValueBuffer {
        private final RowBuffer buffer;
        private final KeyValueWithLevelNoReusingSerializer kvSerializer;

        public BinaryBuffer(RowBuffer buffer, KeyValueWithLevelNoReusingSerializer kvSerializer) {
            this.buffer = buffer;
            this.kvSerializer = kvSerializer;
        }

        @Override
        public void reset() {
            this.buffer.reset();
        }

        @Override
        public void put(KeyValue kv) {
            try {
                boolean success = this.buffer.put(this.kvSerializer.toRow(kv));
                if (!success) {
                    throw new RuntimeException("This is a bug!");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public CloseableIterator<KeyValue> iterator() {
            final RowBuffer.RowBufferIterator iterator = this.buffer.newIterator();
            return new CloseableIterator<KeyValue>(){
                private boolean hasNextWasCalled = false;
                private boolean nextResult = false;

                @Override
                public boolean hasNext() {
                    if (!this.hasNextWasCalled) {
                        this.nextResult = iterator.advanceNext();
                        this.hasNextWasCalled = true;
                    }
                    return this.nextResult;
                }

                @Override
                public KeyValue next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.hasNextWasCalled = false;
                    return kvSerializer.fromRow(iterator.getRow().copy());
                }

                @Override
                public void close() {
                    iterator.close();
                }
            };
        }
    }

    public static class ListBuffer
    implements KeyValueBuffer {
        private final List<KeyValue> list = new ArrayList<KeyValue>();

        @Override
        public CloseableIterator<KeyValue> iterator() {
            return CloseableIterator.adapterForIterator(this.list.iterator());
        }

        @Override
        public void reset() {
            this.list.clear();
        }

        @Override
        public void put(KeyValue kv) {
            this.list.add(kv);
        }
    }

    public static class HybridBuffer
    implements KeyValueBuffer {
        private final int threshold;
        private final ListBuffer listBuffer;
        private final LazyField<BinaryBuffer> lazyBinaryBuffer;
        @Nullable
        private BinaryBuffer binaryBuffer;

        public HybridBuffer(int threshold, LazyField<BinaryBuffer> lazyBinaryBuffer) {
            this.threshold = threshold;
            this.listBuffer = new ListBuffer();
            this.lazyBinaryBuffer = lazyBinaryBuffer;
        }

        @Nullable
        @VisibleForTesting
        BinaryBuffer binaryBuffer() {
            return this.binaryBuffer;
        }

        @Override
        public void reset() {
            this.listBuffer.reset();
            if (this.binaryBuffer != null) {
                this.binaryBuffer.reset();
                this.binaryBuffer = null;
            }
        }

        @Override
        public void put(KeyValue kv) {
            if (this.binaryBuffer != null) {
                this.binaryBuffer.put(kv);
            } else {
                this.listBuffer.put(kv);
                if (this.listBuffer.list.size() > this.threshold) {
                    this.spillToBinary();
                }
            }
        }

        private void spillToBinary() {
            BinaryBuffer binaryBuffer = this.lazyBinaryBuffer.get();
            try (CloseableIterator<KeyValue> iterator = this.listBuffer.iterator();){
                while (iterator.hasNext()) {
                    binaryBuffer.put((KeyValue)iterator.next());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.listBuffer.reset();
            this.binaryBuffer = binaryBuffer;
        }

        @Override
        public CloseableIterator<KeyValue> iterator() {
            if (this.binaryBuffer != null) {
                return this.binaryBuffer.iterator();
            }
            return this.listBuffer.iterator();
        }
    }
}

