/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.paimon.reader.ReaderSupplier;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.Preconditions;

public class ConcatRecordReader<T>
implements RecordReader<T> {
    private final Queue<ReaderSupplier<T>> queue;
    private RecordReader<T> current;

    protected ConcatRecordReader(List<? extends ReaderSupplier<T>> readerFactories) {
        readerFactories.forEach(supplier -> Preconditions.checkNotNull(supplier, "Reader factory must not be null."));
        this.queue = new LinkedList<ReaderSupplier<T>>(readerFactories);
    }

    public static <R> RecordReader<R> create(List<? extends ReaderSupplier<R>> readers) throws IOException {
        return readers.size() == 1 ? readers.get(0).get() : new ConcatRecordReader(readers);
    }

    public static <R> RecordReader<R> create(ReaderSupplier<R> reader1, ReaderSupplier<R> reader2) throws IOException {
        return ConcatRecordReader.create(Arrays.asList(reader1, reader2));
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<T> readBatch() throws IOException {
        while (true) {
            if (this.current != null) {
                RecordReader.RecordIterator<T> iterator = this.current.readBatch();
                if (iterator != null) {
                    return iterator;
                }
                this.current.close();
                this.current = null;
                continue;
            }
            if (this.queue.size() <= 0) break;
            this.current = this.queue.poll().get();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
    }
}

