/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.paimon.utils.Preconditions;
import sun.misc.Unsafe;

public class MemoryUtils {
    public static final Unsafe UNSAFE = MemoryUtils.getUnsafe();
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final long BUFFER_ADDRESS_FIELD_OFFSET = MemoryUtils.getClassFieldOffset(Buffer.class, "address");

    private static Unsafe getUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e) {
            throw new Error("Could not access the sun.misc.Unsafe handle, permission denied by security manager.", e);
        }
        catch (NoSuchFieldException e) {
            throw new Error("The static handle field in sun.misc.Unsafe was not found.", e);
        }
        catch (IllegalArgumentException e) {
            throw new Error("Bug: Illegal argument reflection access for static field.", e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Access to sun.misc.Unsafe is forbidden by the runtime.", e);
        }
        catch (Throwable t) {
            throw new Error("Unclassified error while trying to access the sun.misc.Unsafe handle.", t);
        }
    }

    private static long getClassFieldOffset(Class<?> cl, String fieldName) {
        try {
            return UNSAFE.objectFieldOffset(cl.getDeclaredField(fieldName));
        }
        catch (SecurityException e) {
            throw new Error(MemoryUtils.getClassFieldOffsetErrorMessage(cl, fieldName) + ", permission denied by security manager.", e);
        }
        catch (NoSuchFieldException e) {
            throw new Error(MemoryUtils.getClassFieldOffsetErrorMessage(cl, fieldName), e);
        }
        catch (Throwable t) {
            throw new Error(MemoryUtils.getClassFieldOffsetErrorMessage(cl, fieldName) + ", unclassified error", t);
        }
    }

    private static String getClassFieldOffsetErrorMessage(Class<?> cl, String fieldName) {
        return "Could not get field '" + fieldName + "' offset in class '" + cl + "' for unsafe operations";
    }

    private static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Could not find class '" + className + "' for unsafe operations.", e);
        }
    }

    static long getByteBufferAddress(ByteBuffer buffer) {
        long offHeapAddress;
        Preconditions.checkNotNull(buffer, "buffer is null");
        Preconditions.checkArgument(buffer.isDirect(), "Can't get address of a non-direct ByteBuffer.");
        try {
            offHeapAddress = UNSAFE.getLong(buffer, BUFFER_ADDRESS_FIELD_OFFSET);
        }
        catch (Throwable t) {
            throw new Error("Could not access direct byte buffer address field.", t);
        }
        Preconditions.checkState(offHeapAddress > 0L, "negative pointer or size");
        Preconditions.checkState(offHeapAddress < 9223372034707292160L, "Segment initialized with too large address: " + offHeapAddress + " ; Max allowed address is 9223372034707292159");
        return offHeapAddress;
    }

    private MemoryUtils() {
    }
}

