/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.manifest.ManifestCommittable;

public class WrappedManifestCommittable {
    private final long checkpointId;
    private final long watermark;
    private final Map<Identifier, ManifestCommittable> manifestCommittables;

    public WrappedManifestCommittable(long checkpointId, long watermark) {
        this.checkpointId = checkpointId;
        this.watermark = watermark;
        this.manifestCommittables = new TreeMap<Identifier, ManifestCommittable>(Comparator.comparing(Identifier::getDatabaseName).thenComparing(Identifier::getObjectName));
    }

    public long checkpointId() {
        return this.checkpointId;
    }

    public long watermark() {
        return this.watermark;
    }

    public Map<Identifier, ManifestCommittable> manifestCommittables() {
        return this.manifestCommittables;
    }

    public ManifestCommittable computeCommittableIfAbsent(Identifier identifier, long checkpointId, long watermark) {
        return this.manifestCommittables.computeIfAbsent(identifier, id -> new ManifestCommittable(checkpointId, watermark));
    }

    public void putManifestCommittable(Identifier identifier, ManifestCommittable manifestCommittable) {
        this.manifestCommittables.put(identifier, manifestCommittable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedManifestCommittable that = (WrappedManifestCommittable)o;
        return this.checkpointId == that.checkpointId && this.watermark == that.watermark && Objects.equals(this.manifestCommittables, that.manifestCommittables);
    }

    public int hashCode() {
        return Objects.hash(this.checkpointId, this.watermark, this.manifestCommittables);
    }

    public String toString() {
        return "WrappedManifestCommittable{checkpointId=" + this.checkpointId + ", watermark=" + this.watermark + ", manifestCommittables=" + this.manifestCommittables + "}";
    }
}

