/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.Segments;

public class ManifestEntrySegments
implements Segments {
    private final List<RichSegments> segments;
    private final long totalMemorySize;
    private final Map<BinaryRow, Map<Integer, List<RichSegments>>> indexedSegments;

    public ManifestEntrySegments(List<RichSegments> segments) {
        this.segments = segments;
        this.totalMemorySize = segments.stream().map(RichSegments::segments).mapToLong(Segments::totalMemorySize).sum();
        this.indexedSegments = new HashMap<BinaryRow, Map<Integer, List<RichSegments>>>();
        for (RichSegments seg : segments) {
            this.indexedSegments.computeIfAbsent(seg.partition(), k -> new HashMap()).computeIfAbsent(seg.bucket(), k -> new ArrayList()).add(seg);
        }
    }

    public List<RichSegments> segments() {
        return this.segments;
    }

    public Map<BinaryRow, Map<Integer, List<RichSegments>>> indexedSegments() {
        return this.indexedSegments;
    }

    @Override
    public long totalMemorySize() {
        return this.totalMemorySize;
    }

    public static class RichSegments {
        private final BinaryRow partition;
        private final int bucket;
        private final int totalBucket;
        private final Segments segments;

        public RichSegments(BinaryRow partition, int bucket, int totalBucket, Segments segments) {
            this.partition = partition;
            this.bucket = bucket;
            this.totalBucket = totalBucket;
            this.segments = segments;
        }

        public BinaryRow partition() {
            return this.partition;
        }

        public int bucket() {
            return this.bucket;
        }

        public int totalBucket() {
            return this.totalBucket;
        }

        public Segments segments() {
            return this.segments;
        }
    }
}

