/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Segments;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.BucketFilter;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestEntryFilters;
import org.apache.paimon.manifest.ManifestEntrySegments;
import org.apache.paimon.manifest.ManifestEntrySerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentSource;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BiFunctionWithIOE;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsCache;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SimpleObjectsCache;
import org.apache.paimon.utils.Triple;

@ThreadSafe
public class ManifestEntryCache
extends ObjectsCache<Path, ManifestEntry, ManifestEntrySegments> {
    public ManifestEntryCache(SegmentsCache<Path> cache, ObjectSerializer<ManifestEntry> projectedSerializer, RowType formatSchema, FunctionWithIOException<Path, Long> fileSizeFunction, BiFunctionWithIOE<Path, Long, CloseableIterator<InternalRow>> reader) {
        super(cache, projectedSerializer, formatSchema, fileSizeFunction, reader);
    }

    @Override
    protected ManifestEntrySegments createSegments(Path path, @Nullable Long fileSize) {
        ManifestEntrySegments manifestEntrySegments;
        block10: {
            HashMap<Triple, SimpleCollectingOutputView> segments = new HashMap<Triple, SimpleCollectingOutputView>();
            Function<InternalRow, BinaryRow> partitionGetter = ManifestEntrySerializer.partitionGetter();
            Function<InternalRow, Integer> bucketGetter = ManifestEntrySerializer.bucketGetter();
            Function<InternalRow, Integer> totalBucketGetter = ManifestEntrySerializer.totalBucketGetter();
            MemorySegmentSource segmentSource = () -> MemorySegment.allocateHeapMemory(this.cache.pageSize());
            Supplier<SimpleCollectingOutputView> outViewSupplier = () -> new SimpleCollectingOutputView(new ArrayList<MemorySegment>(), segmentSource, this.cache.pageSize());
            InternalRowSerializer formatSerializer = (InternalRowSerializer)this.formatSerializer.get();
            CloseableIterator iterator = (CloseableIterator)this.reader.apply(path, fileSize);
            try {
                while (iterator.hasNext()) {
                    InternalRow row = (InternalRow)iterator.next();
                    BinaryRow partition = partitionGetter.apply(row);
                    int bucket = bucketGetter.apply(row);
                    int totalBucket = totalBucketGetter.apply(row);
                    Triple<BinaryRow, Integer, Integer> key = Triple.of(partition, bucket, totalBucket);
                    SimpleCollectingOutputView view = segments.computeIfAbsent(key, k -> (SimpleCollectingOutputView)outViewSupplier.get());
                    formatSerializer.serializeToPages(row, (AbstractPagedOutputView)view);
                }
                ArrayList<ManifestEntrySegments.RichSegments> result = new ArrayList<ManifestEntrySegments.RichSegments>();
                for (Map.Entry entry : segments.entrySet()) {
                    Triple key = (Triple)entry.getKey();
                    SimpleCollectingOutputView view = (SimpleCollectingOutputView)entry.getValue();
                    Segments seg = Segments.create(view.fullSegments(), view.getCurrentPositionInSegment());
                    result.add(new ManifestEntrySegments.RichSegments((BinaryRow)key.f0, (Integer)key.f1, (Integer)key.f2, seg));
                }
                manifestEntrySegments = new ManifestEntrySegments(result);
                if (iterator == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            iterator.close();
        }
        return manifestEntrySegments;
    }

    @Override
    protected List<ManifestEntry> readFromSegments(ManifestEntrySegments manifestSegments, ObjectsCache.Filters<ManifestEntry> filters) throws IOException {
        PartitionPredicate partitionFilter = null;
        BucketFilter bucketFilter = null;
        if (filters instanceof ManifestEntryFilters) {
            partitionFilter = ((ManifestEntryFilters)filters).partitionFilter;
            bucketFilter = ((ManifestEntryFilters)filters).bucketFilter;
        }
        List<ManifestEntrySegments.RichSegments> segments = manifestSegments.segments();
        Optional<BinaryRow> partition = this.extractSinglePartition(partitionFilter);
        if (partition.isPresent()) {
            Map<Integer, List<ManifestEntrySegments.RichSegments>> segMap = manifestSegments.indexedSegments().get(partition.get());
            if (segMap == null) {
                return Collections.emptyList();
            }
            OptionalInt specifiedBucket = this.extractSpecifiedBucket(bucketFilter);
            if (specifiedBucket.isPresent()) {
                segments = segMap.get(specifiedBucket.getAsInt());
                if (segments == null) {
                    return Collections.emptyList();
                }
            } else {
                segments = segMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
        }
        ArrayList<Segments> segmentsList = new ArrayList<Segments>();
        for (ManifestEntrySegments.RichSegments richSegments : segments) {
            if (partitionFilter != null && !partitionFilter.test(richSegments.partition()) || bucketFilter != null && !bucketFilter.test(richSegments.bucket(), richSegments.totalBucket())) continue;
            segmentsList.add(richSegments.segments());
        }
        ArrayList<ManifestEntry> result = new ArrayList<ManifestEntry>();
        InternalRowSerializer formatSerializer = (InternalRowSerializer)this.formatSerializer.get();
        for (Segments subSegments : segmentsList) {
            result.addAll(SimpleObjectsCache.readFromSegments(formatSerializer, this.projectedSerializer, subSegments, filters));
        }
        return result;
    }

    private Optional<BinaryRow> extractSinglePartition(@Nullable PartitionPredicate predicate) {
        if (predicate instanceof PartitionPredicate.MultiplePartitionPredicate) {
            return ((PartitionPredicate.MultiplePartitionPredicate)predicate).extractSinglePartition();
        }
        return Optional.empty();
    }

    private OptionalInt extractSpecifiedBucket(@Nullable BucketFilter filter) {
        Integer specifiedBucket;
        if (filter != null && (specifiedBucket = filter.specifiedBucket()) != null) {
            return OptionalInt.of(specifiedBucket);
        }
        return OptionalInt.empty();
    }
}

