/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.util.Objects;
import org.apache.paimon.compression.BlockCompressionType;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceInput;
import org.apache.paimon.memory.MemorySliceOutput;

public class BlockTrailer {
    public static final int ENCODED_LENGTH = 5;
    private final BlockCompressionType compressionType;
    private final int crc32c;

    public BlockTrailer(BlockCompressionType compressionType, int crc32c) {
        Objects.requireNonNull(compressionType, "compressionType is null");
        this.compressionType = compressionType;
        this.crc32c = crc32c;
    }

    public BlockCompressionType getCompressionType() {
        return this.compressionType;
    }

    public int getCrc32c() {
        return this.crc32c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockTrailer that = (BlockTrailer)o;
        if (this.crc32c != that.crc32c) {
            return false;
        }
        return this.compressionType == that.compressionType;
    }

    public int hashCode() {
        int result = this.compressionType.hashCode();
        result = 31 * result + this.crc32c;
        return result;
    }

    public String toString() {
        return "BlockTrailer{compressionType=" + this.compressionType + ", crc32c=0x" + Integer.toHexString(this.crc32c) + "}";
    }

    public static BlockTrailer readBlockTrailer(MemorySliceInput input) {
        BlockCompressionType compressionType = BlockCompressionType.getCompressionTypeByPersistentId(input.readUnsignedByte());
        int crc32c = input.readInt();
        return new BlockTrailer(compressionType, crc32c);
    }

    public static MemorySlice writeBlockTrailer(BlockTrailer blockTrailer) {
        MemorySliceOutput output = new MemorySliceOutput(5);
        BlockTrailer.writeBlockTrailer(blockTrailer, output);
        return output.toSlice();
    }

    public static void writeBlockTrailer(BlockTrailer blockTrailer, MemorySliceOutput sliceOutput) {
        sliceOutput.writeByte(blockTrailer.getCompressionType().persistentId());
        sliceOutput.writeInt(blockTrailer.getCrc32c());
    }
}

