/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.jdbc.JdbcUtils;

public class JdbcClientPool
extends ClientPool.ClientPoolImpl<Connection, SQLException> {
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("jdbc:([^:]+):(.*)");
    private final String protocol;

    public JdbcClientPool(int poolSize, String dbUrl, Map<String, String> props) {
        super(poolSize, JdbcClientPool.clientSupplier(dbUrl, props));
        Matcher matcher = PROTOCOL_PATTERN.matcher(dbUrl);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid Jdbc url: " + dbUrl);
        }
        this.protocol = matcher.group(1);
    }

    private static Supplier<Connection> clientSupplier(String dbUrl, Map<String, String> props) {
        return () -> {
            try {
                Properties dbProps = JdbcUtils.extractJdbcConfiguration(props, "jdbc.");
                return DriverManager.getConnection(dbUrl, dbProps);
            }
            catch (SQLException e) {
                throw new RuntimeException(String.format("Failed to connect: %s", dbUrl), e);
            }
        };
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    protected void close(Connection client) {
        try {
            client.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to close connection", e);
        }
    }
}

