/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.PartitionSettedRow;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.casting.FallbackMappingRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.ProjectedRow;

public class DataFileRecordReader
implements FileRecordReader<InternalRow> {
    private final RowType tableRowType;
    private final FileRecordReader<InternalRow> reader;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final PartitionInfo partitionInfo;
    @Nullable
    private final CastFieldGetter[] castMapping;
    private final boolean rowTrackingEnabled;
    @Nullable
    private final Long firstRowId;
    private final long maxSequenceNumber;
    private final Map<String, Integer> systemFields;

    public DataFileRecordReader(RowType tableRowType, FormatReaderFactory readerFactory, FormatReaderFactory.Context context, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping, @Nullable PartitionInfo partitionInfo, boolean rowTrackingEnabled, @Nullable Long firstRowId, long maxSequenceNumber, Map<String, Integer> systemFields) throws IOException {
        this.tableRowType = tableRowType;
        try {
            this.reader = readerFactory.createReader(context);
        }
        catch (Exception e) {
            FileUtils.checkExists(context.fileIO(), context.filePath());
            throw e;
        }
        this.indexMapping = indexMapping;
        this.partitionInfo = partitionInfo;
        this.castMapping = castMapping;
        this.rowTrackingEnabled = rowTrackingEnabled;
        this.firstRowId = firstRowId;
        this.maxSequenceNumber = maxSequenceNumber;
        this.systemFields = systemFields;
    }

    @Override
    @Nullable
    public FileRecordIterator<InternalRow> readBatch() throws IOException {
        RecordReader.RecordIterator iterator = this.reader.readBatch();
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof ColumnarRowIterator) {
            iterator = ((ColumnarRowIterator)iterator).mapping(this.partitionInfo, this.indexMapping);
            if (this.rowTrackingEnabled) {
                iterator = ((ColumnarRowIterator)iterator).assignRowTracking(this.firstRowId, this.maxSequenceNumber, this.systemFields);
            }
        } else {
            if (this.partitionInfo != null) {
                PartitionSettedRow partitionSettedRow = PartitionSettedRow.from(this.partitionInfo);
                iterator = iterator.transform(partitionSettedRow::replaceRow);
            }
            if (this.indexMapping != null) {
                ProjectedRow projectedRow = ProjectedRow.from(this.indexMapping);
                iterator = iterator.transform(projectedRow::replaceRow);
            }
            if (this.rowTrackingEnabled && !this.systemFields.isEmpty()) {
                GenericRow trackingRow = new GenericRow(2);
                int[] fallbackToTrackingMappings = new int[this.tableRowType.getFieldCount()];
                Arrays.fill(fallbackToTrackingMappings, -1);
                if (this.systemFields.containsKey(SpecialFields.ROW_ID.name())) {
                    fallbackToTrackingMappings[this.systemFields.get((Object)SpecialFields.ROW_ID.name()).intValue()] = 0;
                }
                if (this.systemFields.containsKey(SpecialFields.SEQUENCE_NUMBER.name())) {
                    fallbackToTrackingMappings[this.systemFields.get((Object)SpecialFields.SEQUENCE_NUMBER.name()).intValue()] = 1;
                }
                FallbackMappingRow fallbackMappingRow = new FallbackMappingRow(fallbackToTrackingMappings);
                RecordReader.RecordIterator iteratorInner = iterator;
                iterator = iterator.transform(arg_0 -> this.lambda$readBatch$0(trackingRow, (FileRecordIterator)iteratorInner, fallbackMappingRow, arg_0));
            }
        }
        if (this.castMapping != null) {
            CastedRow castedRow = CastedRow.from(this.castMapping);
            iterator = iterator.transform(castedRow::replaceRow);
        }
        return iterator;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private /* synthetic */ InternalRow lambda$readBatch$0(GenericRow trackingRow, FileRecordIterator iteratorInner, FallbackMappingRow fallbackMappingRow, InternalRow row) {
        if (this.firstRowId != null) {
            trackingRow.setField(0, iteratorInner.returnedPosition() + this.firstRowId);
        }
        trackingRow.setField(1, this.maxSequenceNumber);
        return fallbackMappingRow.replace(row, trackingRow);
    }
}

