/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.format.HadoopCompressionType;
import org.apache.paimon.fs.ExternalPathProvider;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

@ThreadSafe
public class DataFilePathFactory {
    public static final String INDEX_PATH_SUFFIX = ".index";
    private final Path parent;
    private final String uuid;
    private final AtomicInteger pathCount;
    private final String formatIdentifier;
    private final String dataFilePrefix;
    private final String changelogFilePrefix;
    private final boolean fileSuffixIncludeCompression;
    @Nullable
    private final String compressExtension;
    @Nullable
    private final ExternalPathProvider externalPathProvider;

    public DataFilePathFactory(Path parent, String formatIdentifier, String dataFilePrefix, String changelogFilePrefix, boolean fileSuffixIncludeCompression, String fileCompression, @Nullable ExternalPathProvider externalPathProvider) {
        this.parent = parent;
        this.uuid = UUID.randomUUID().toString();
        this.pathCount = new AtomicInteger(0);
        this.formatIdentifier = formatIdentifier;
        this.dataFilePrefix = dataFilePrefix;
        this.changelogFilePrefix = changelogFilePrefix;
        this.fileSuffixIncludeCompression = fileSuffixIncludeCompression;
        this.compressExtension = DataFilePathFactory.compressFileExtension(fileCompression);
        this.externalPathProvider = externalPathProvider;
    }

    public Path parent() {
        return this.parent;
    }

    public String dataFilePrefix() {
        return this.dataFilePrefix;
    }

    public Path newPath() {
        return this.newPath(this.dataFilePrefix);
    }

    public Path newChangelogPath() {
        return this.newPath(this.changelogFilePrefix);
    }

    public String newChangelogFileName() {
        return this.newFileName(this.changelogFilePrefix);
    }

    public Path newPath(String prefix) {
        return this.newPathFromName(this.newFileName(prefix));
    }

    private String newFileName(String prefix) {
        String extension = this.compressExtension != null && DataFilePathFactory.isTextFormat(this.formatIdentifier) ? "." + this.formatIdentifier + "." + this.compressExtension : (this.compressExtension != null && this.fileSuffixIncludeCompression ? "." + this.compressExtension + "." + this.formatIdentifier : "." + this.formatIdentifier);
        return this.newFileName(prefix, extension);
    }

    public Path newPathFromExtension(String extension) {
        return this.newPathFromName(this.newFileName(this.dataFilePrefix, extension));
    }

    public Path newPathFromName(String fileName) {
        if (this.externalPathProvider != null) {
            return this.externalPathProvider.getNextExternalDataPath(fileName);
        }
        return new Path(this.parent, fileName);
    }

    private String newFileName(String prefix, String extension) {
        return prefix + this.uuid + "-" + this.pathCount.getAndIncrement() + extension;
    }

    public Path toPath(DataFileMeta file) {
        return file.externalPath().map(Path::new).orElse(new Path(this.parent, file.fileName()));
    }

    public Path toPath(FileEntry file) {
        return Optional.ofNullable(file.externalPath()).map(Path::new).orElse(new Path(this.parent, file.fileName()));
    }

    public Path toAlignedPath(String fileName, DataFileMeta aligned) {
        return new Path(aligned.externalPathDir().map(Path::new).orElse(this.parent), fileName);
    }

    public Path toAlignedPath(String fileName, FileEntry aligned) {
        Optional<String> externalPathDir = Optional.ofNullable(aligned.externalPath()).map(Path::new).map(p -> p.getParent().toUri().toString());
        return new Path(externalPathDir.map(Path::new).orElse(this.parent), fileName);
    }

    public static Path dataFileToFileIndexPath(Path dataFilePath) {
        return new Path(dataFilePath.getParent(), dataFilePath.getName() + INDEX_PATH_SUFFIX);
    }

    public static Path createNewFileIndexFilePath(Path filePath) {
        String fileName = filePath.getName();
        int dot = fileName.lastIndexOf(".");
        int dash = fileName.lastIndexOf("-");
        if (dash != -1) {
            try {
                int num = Integer.parseInt(fileName.substring(dash + 1, dot));
                return new Path(filePath.getParent(), fileName.substring(0, dash + 1) + (num + 1) + INDEX_PATH_SUFFIX);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Path(filePath.getParent(), fileName.substring(0, dot) + "-1.index");
    }

    public static String formatIdentifier(String fileName) {
        int index = fileName.lastIndexOf(46);
        Preconditions.checkArgument(index != -1, "%s is not a legal file name.", fileName);
        String extension = fileName.substring(index + 1);
        if (HadoopCompressionType.isCompressExtension(extension)) {
            int secondLastDot = fileName.lastIndexOf(46, index - 1);
            Preconditions.checkArgument(secondLastDot != -1, "%s is not a legal file name.", fileName);
            return fileName.substring(secondLastDot + 1, index);
        }
        return extension;
    }

    public boolean isExternalPath() {
        return this.externalPathProvider != null;
    }

    @VisibleForTesting
    String uuid() {
        return this.uuid;
    }

    private static boolean isTextFormat(String formatIdentifier) {
        return "json".equalsIgnoreCase(formatIdentifier) || "csv".equalsIgnoreCase(formatIdentifier);
    }

    @Nullable
    private static String compressFileExtension(String compression) {
        if (StringUtils.isEmpty(compression)) {
            return null;
        }
        Optional<HadoopCompressionType> hadoopOptional = HadoopCompressionType.fromValue(compression);
        if (hadoopOptional.isPresent()) {
            return hadoopOptional.get().fileExtension();
        }
        return compression;
    }
}

