/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerializationUtils;

public class IndexFileMetaV2Deserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_INDEX_TYPE", SerializationUtils.newStringType(false)), new DataField(1, "_FILE_NAME", SerializationUtils.newStringType(false)), new DataField(2, "_FILE_SIZE", new BigIntType(false)), new DataField(3, "_ROW_COUNT", new BigIntType(false)), new DataField(4, "_DELETIONS_VECTORS_RANGES", new ArrayType(true, DeletionVectorMeta.SCHEMA))));
    protected final InternalRowSerializer rowSerializer = InternalSerializers.create(SCHEMA);

    public IndexFileMeta fromRow(InternalRow row) {
        return new IndexFileMeta(row.getString(0).toString(), row.getString(1).toString(), row.getLong(2), row.getLong(3), row.isNullAt(4) ? null : IndexFileMetaSerializer.rowArrayDataToDvMetas(row.getArray(4)), null);
    }

    public final List<IndexFileMeta> deserializeList(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<IndexFileMeta> records = new ArrayList<IndexFileMeta>(size);
        for (int i = 0; i < size; ++i) {
            records.add(this.deserialize(source));
        }
        return records;
    }

    public IndexFileMeta deserialize(DataInputView in) throws IOException {
        return this.fromRow(this.rowSerializer.deserialize(in));
    }
}

