/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerializationUtils;

@Public
public class IndexFileMeta {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_INDEX_TYPE", SerializationUtils.newStringType(false)), new DataField(1, "_FILE_NAME", SerializationUtils.newStringType(false)), new DataField(2, "_FILE_SIZE", new BigIntType(false)), new DataField(3, "_ROW_COUNT", new BigIntType(false)), new DataField(4, "_DELETIONS_VECTORS_RANGES", new ArrayType(true, DeletionVectorMeta.SCHEMA)), new DataField(5, "_EXTERNAL_PATH", SerializationUtils.newStringType(true))));
    private final String indexType;
    private final String fileName;
    private final long fileSize;
    private final long rowCount;
    @Nullable
    private final LinkedHashMap<String, DeletionVectorMeta> dvRanges;
    @Nullable
    private final String externalPath;

    public IndexFileMeta(String indexType, String fileName, long fileSize, long rowCount, @Nullable LinkedHashMap<String, DeletionVectorMeta> dvRanges, @Nullable String externalPath) {
        this.indexType = indexType;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
        this.dvRanges = dvRanges;
        this.externalPath = externalPath;
    }

    public String indexType() {
        return this.indexType;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long rowCount() {
        return this.rowCount;
    }

    @Nullable
    public LinkedHashMap<String, DeletionVectorMeta> dvRanges() {
        return this.dvRanges;
    }

    @Nullable
    public String externalPath() {
        return this.externalPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFileMeta that = (IndexFileMeta)o;
        return Objects.equals(this.indexType, that.indexType) && Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.rowCount == that.rowCount && Objects.equals(this.dvRanges, that.dvRanges) && Objects.equals(this.externalPath, that.externalPath);
    }

    public int hashCode() {
        return Objects.hash(this.indexType, this.fileName, this.fileSize, this.rowCount, this.dvRanges, this.externalPath);
    }

    public String toString() {
        return "IndexManifestEntry{indexType=" + this.indexType + ", fileName='" + this.fileName + "', fileSize=" + this.fileSize + ", rowCount=" + this.rowCount + ", dvRanges=" + this.dvRanges + ", externalPath='" + this.externalPath + "}";
    }
}

