/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFile;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.IndexFilePathFactories;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SnapshotManager;

public class IndexFileHandler {
    private final FileIO fileIO;
    private final SnapshotManager snapshotManager;
    private final IndexManifestFile indexManifestFile;
    private final IndexFilePathFactories pathFactories;
    private final MemorySize dvTargetFileSize;
    private final boolean dvBitmap64;

    public IndexFileHandler(FileIO fileIO, SnapshotManager snapshotManager, IndexManifestFile indexManifestFile, IndexFilePathFactories pathFactories, MemorySize dvTargetFileSize, boolean dvBitmap64) {
        this.fileIO = fileIO;
        this.snapshotManager = snapshotManager;
        this.pathFactories = pathFactories;
        this.indexManifestFile = indexManifestFile;
        this.dvTargetFileSize = dvTargetFileSize;
        this.dvBitmap64 = dvBitmap64;
    }

    public HashIndexFile hashIndex(BinaryRow partition, int bucket) {
        return new HashIndexFile(this.fileIO, this.pathFactories.get(partition, bucket));
    }

    public DeletionVectorsIndexFile dvIndex(BinaryRow partition, int bucket) {
        return new DeletionVectorsIndexFile(this.fileIO, this.pathFactories.get(partition, bucket), this.dvTargetFileSize, this.dvBitmap64);
    }

    public Optional<IndexFileMeta> scanHashIndex(Snapshot snapshot, BinaryRow partition, int bucket) {
        List<IndexFileMeta> result = this.scan(snapshot, "HASH", partition, bucket);
        if (result.size() > 1) {
            throw new IllegalArgumentException("Find multiple hash index files for one bucket: " + result);
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }

    public List<IndexManifestEntry> scan(String indexType) {
        return this.scan(this.snapshotManager.latestSnapshot(), indexType);
    }

    public List<IndexManifestEntry> scan(Snapshot snapshot, String indexType) {
        if (snapshot == null) {
            return Collections.emptyList();
        }
        String indexManifest = snapshot.indexManifest();
        if (indexManifest == null) {
            return Collections.emptyList();
        }
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : this.indexManifestFile.read(indexManifest)) {
            if (!file.indexFile().indexType().equals(indexType)) continue;
            result.add(file);
        }
        return result;
    }

    public List<IndexFileMeta> scan(Snapshot snapshot, String indexType, BinaryRow partition, int bucket) {
        ArrayList<IndexFileMeta> result = new ArrayList<IndexFileMeta>();
        for (IndexManifestEntry file : this.scanEntries(snapshot, indexType, partition)) {
            if (file.bucket() != bucket) continue;
            result.add(file.indexFile());
        }
        return result;
    }

    public Map<Pair<BinaryRow, Integer>, List<IndexFileMeta>> scan(long snapshot, String indexType, Set<BinaryRow> partitions) {
        return this.scan(this.snapshotManager.snapshot(snapshot), indexType, partitions);
    }

    public Map<Pair<BinaryRow, Integer>, List<IndexFileMeta>> scan(Snapshot snapshot, String indexType, Set<BinaryRow> partitions) {
        HashMap<Pair<BinaryRow, Integer>, List<IndexFileMeta>> result = new HashMap<Pair<BinaryRow, Integer>, List<IndexFileMeta>>();
        for (IndexManifestEntry file : this.scanEntries(snapshot, indexType, partitions)) {
            result.computeIfAbsent(Pair.of(file.partition(), file.bucket()), k -> new ArrayList()).add(file.indexFile());
        }
        return result;
    }

    public List<IndexManifestEntry> scanEntries() {
        Snapshot snapshot = this.snapshotManager.latestSnapshot();
        if (snapshot == null || snapshot.indexManifest() == null) {
            return Collections.emptyList();
        }
        return this.indexManifestFile.read(snapshot.indexManifest());
    }

    public List<IndexManifestEntry> scanEntries(String indexType, BinaryRow partition) {
        Snapshot snapshot = this.snapshotManager.latestSnapshot();
        if (snapshot == null) {
            return Collections.emptyList();
        }
        return this.scanEntries(snapshot, indexType, partition);
    }

    public List<IndexManifestEntry> scanEntries(Snapshot snapshot, String indexType, BinaryRow partition) {
        return this.scanEntries(snapshot, indexType, Collections.singleton(partition));
    }

    public List<IndexManifestEntry> scanEntries(Snapshot snapshot, String indexType, Set<BinaryRow> partitions) {
        List<IndexManifestEntry> manifestEntries = this.scan(snapshot, indexType);
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry file : manifestEntries) {
            if (!partitions.contains(file.partition())) continue;
            result.add(file);
        }
        return result;
    }

    public Path filePath(IndexManifestEntry entry) {
        return this.pathFactories.get(entry.partition(), entry.bucket()).toPath(entry.indexFile());
    }

    public boolean existsManifest(String indexManifest) {
        return this.indexManifestFile.exists(indexManifest);
    }

    public List<IndexManifestEntry> readManifest(String indexManifest) {
        return this.indexManifestFile.read(indexManifest);
    }

    public List<IndexManifestEntry> readManifestWithIOException(String indexManifest) throws IOException {
        return this.indexManifestFile.readWithIOException(indexManifest);
    }

    private IndexFile indexFile(IndexManifestEntry entry) {
        IndexFileMeta file = entry.indexFile();
        switch (file.indexType()) {
            case "HASH": {
                return this.hashIndex(entry.partition(), entry.bucket());
            }
            case "DELETION_VECTORS": {
                return this.dvIndex(entry.partition(), entry.bucket());
            }
        }
        throw new IllegalArgumentException("Unknown index type: " + file.indexType());
    }

    public boolean existsIndexFile(IndexManifestEntry file) {
        return this.indexFile(file).exists(file.indexFile());
    }

    public void deleteIndexFile(IndexManifestEntry entry) {
        this.indexFile(entry).delete(entry.indexFile());
    }

    public void deleteManifest(String indexManifest) {
        this.indexManifestFile.delete(indexManifest);
    }

    public Map<String, DeletionVector> readAllDeletionVectors(BinaryRow partition, int bucket, List<IndexFileMeta> fileMetas) {
        return this.dvIndex(partition, bucket).readAllDeletionVectors(fileMetas);
    }

    public Map<String, DeletionVector> readAllDeletionVectors(IndexManifestEntry entry) {
        return this.dvIndex(entry.partition(), entry.bucket()).readAllDeletionVectors(entry.indexFile());
    }
}

