/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexPathFactory;

public abstract class IndexFile {
    protected final FileIO fileIO;
    protected final IndexPathFactory pathFactory;

    public IndexFile(FileIO fileIO, IndexPathFactory pathFactory) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
    }

    public Path path(IndexFileMeta file) {
        return this.pathFactory.toPath(file);
    }

    public long fileSize(IndexFileMeta file) {
        return this.fileSize(this.path(file));
    }

    public long fileSize(Path file) {
        try {
            return this.fileIO.getFileSize(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void delete(IndexFileMeta file) {
        this.fileIO.deleteQuietly(this.path(file));
    }

    public boolean exists(IndexFileMeta file) {
        try {
            return this.fileIO.exists(this.path(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isExternalPath() {
        return this.pathFactory.isExternalPath();
    }
}

