/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.utils.IntHashSet;
import org.apache.paimon.utils.IntIterator;

public class DynamicBucketIndexMaintainer {
    private final HashIndexFile indexFile;
    private final IntHashSet hashcode;
    private boolean modified;

    private DynamicBucketIndexMaintainer(HashIndexFile indexFile, @Nullable IndexFileMeta restoredFile) {
        this.indexFile = indexFile;
        IntHashSet hashcode = new IntHashSet();
        if (restoredFile != null) {
            hashcode = new IntHashSet((int)restoredFile.rowCount());
            this.restore(indexFile, hashcode, restoredFile);
        }
        this.hashcode = hashcode;
        this.modified = false;
    }

    private void restore(HashIndexFile indexFile, IntHashSet hashcode, IndexFileMeta file) {
        try {
            IntIterator iterator = indexFile.read(file);
            try {
                try {
                    while (true) {
                        hashcode.add(iterator.next());
                    }
                }
                catch (EOFException ignored) {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (iterator != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void notifyNewRecord(KeyValue record) {
        InternalRow key = record.key();
        if (!(key instanceof BinaryRow)) {
            throw new IllegalArgumentException("Unsupported key type: " + key.getClass());
        }
        boolean changed = this.hashcode.add(key.hashCode());
        if (changed) {
            this.modified = true;
        }
    }

    public List<IndexFileMeta> prepareCommit() {
        if (this.modified) {
            IndexFileMeta entry;
            try {
                entry = this.indexFile.write(this.hashcode.toIntIterator());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.modified = false;
            return Collections.singletonList(entry);
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    public boolean isEmpty() {
        return this.hashcode.size() == 0;
    }

    public static class Factory {
        private final IndexFileHandler handler;

        public Factory(IndexFileHandler handler) {
            this.handler = handler;
        }

        public IndexFileHandler indexFileHandler() {
            return this.handler;
        }

        public DynamicBucketIndexMaintainer create(BinaryRow partition, int bucket, @Nullable IndexFileMeta restoredFile) {
            return new DynamicBucketIndexMaintainer(this.handler.hashIndex(partition, bucket), restoredFile);
        }
    }
}

