/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.pool;

import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.hive.RetryingMetaStoreClientFactory;
import org.apache.thrift.TException;

public class HiveClientPool
extends ClientPool.ClientPoolImpl<IMetaStoreClient, TException> {
    public HiveClientPool(int poolSize, Configuration conf, String clientClassName) {
        super(poolSize, HiveClientPool.clientSupplier(conf, clientClassName));
    }

    private static Supplier<IMetaStoreClient> clientSupplier(Configuration conf, String clientClassName) {
        HiveConf hiveConf = new HiveConf(conf, HiveClientPool.class);
        hiveConf.addResource(conf);
        return () -> new RetryingMetaStoreClientFactory().createClient(hiveConf, clientClassName);
    }

    @Override
    protected void close(IMetaStoreClient client) {
        client.close();
    }
}

