/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hash;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.RandomAccessInputView;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.data.serializer.PagedTypeSerializer;
import org.apache.paimon.hash.BytesHashMap;
import org.apache.paimon.hash.BytesMap;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.KeyValueIterator;
import org.apache.paimon.utils.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesHashMap<K>
extends BytesMap<K, BinaryRow> {
    private static final Logger LOG = LoggerFactory.getLogger(BytesHashMap.class);
    private final boolean hashSetMode;
    protected final PagedTypeSerializer<K> keySerializer;
    private final BinaryRowSerializer valueSerializer;
    private volatile EntryIterator destructiveIterator = null;

    public BytesHashMap(MemorySegmentPool memoryPool, PagedTypeSerializer<K> keySerializer, int valueArity) {
        super(memoryPool, keySerializer);
        this.recordArea = new RecordArea();
        this.keySerializer = keySerializer;
        this.valueSerializer = new BinaryRowSerializer(valueArity);
        if (valueArity == 0) {
            this.hashSetMode = true;
            this.reusedValue = new BinaryRow(0);
            ((BinaryRow)this.reusedValue).pointTo(MemorySegment.wrap(new byte[8]), 0, 8);
            LOG.info("BytesHashMap with hashSetMode = true.");
        } else {
            this.hashSetMode = false;
            this.reusedValue = this.valueSerializer.createInstance();
        }
        int initBucketSegmentNum = MathUtils.roundDownToPowerOf2((int)(0x100000L / (long)this.segmentSize));
        this.initBucketSegments(initBucketSegmentNum);
        LOG.info("BytesHashMap with initial memory segments {}, {} in bytes, init allocating {} for bucket area.", new Object[]{this.reservedNumBuffers, this.reservedNumBuffers * this.segmentSize, initBucketSegmentNum});
    }

    @Override
    public long getNumKeys() {
        return this.numElements;
    }

    public BinaryRow append(BytesMap.LookupInfo<K, BinaryRow> lookupInfo, BinaryRow value) throws IOException {
        try {
            if (this.numElements >= this.growthThreshold) {
                this.growAndRehash();
                this.lookup(lookupInfo.key);
            }
            BinaryRow toAppend = this.hashSetMode ? (BinaryRow)this.reusedValue : value;
            int pointerToAppended = this.recordArea.appendRecord(lookupInfo, toAppend);
            ((MemorySegment)this.bucketSegments.get(lookupInfo.bucketSegmentIndex)).putInt(lookupInfo.bucketOffset, pointerToAppended);
            ((MemorySegment)this.bucketSegments.get(lookupInfo.bucketSegmentIndex)).putInt(lookupInfo.bucketOffset + 4, lookupInfo.keyHashCode);
            ++this.numElements;
            this.recordArea.setReadPosition(pointerToAppended);
            ((RecordArea)this.recordArea).skipKey();
            return this.recordArea.readValue((BinaryRow)this.reusedValue);
        }
        catch (EOFException e) {
            ++this.numSpillFiles;
            this.spillInBytes += this.recordArea.getSegmentsSize();
            throw e;
        }
    }

    @Override
    public long getNumSpillFiles() {
        return this.numSpillFiles;
    }

    public long getUsedMemoryInBytes() {
        return (long)this.bucketSegments.size() * (long)this.segmentSize + this.recordArea.getSegmentsSize();
    }

    @Override
    public long getSpillInBytes() {
        return this.spillInBytes;
    }

    @Override
    public int getNumElements() {
        return this.numElements;
    }

    public KeyValueIterator<K, BinaryRow> getEntryIterator(boolean requiresCopy) {
        if (this.destructiveIterator != null) {
            throw new IllegalArgumentException("DestructiveIterator is not null, so this method can't be invoke!");
        }
        return ((RecordArea)this.recordArea).entryIterator(requiresCopy);
    }

    public ArrayList<MemorySegment> getRecordAreaMemorySegments() {
        return ((RecordArea)this.recordArea).segments;
    }

    public List<MemorySegment> getBucketAreaMemorySegments() {
        return this.bucketSegments;
    }

    @Override
    public void free() {
        this.recordArea.release();
        this.destructiveIterator = null;
        super.free();
    }

    @Override
    public void reset() {
        this.recordArea.reset();
        this.destructiveIterator = null;
        super.reset();
    }

    @VisibleForTesting
    boolean isHashSetMode() {
        return this.hashSetMode;
    }

    static int getVariableLength(DataType[] types) {
        int length = 0;
        for (DataType type : types) {
            if (BinaryRow.isInFixedLengthPart(type)) continue;
            length += 16;
        }
        return length;
    }

    private final class RecordArea
    implements BytesMap.RecordArea<K, BinaryRow> {
        private final ArrayList<MemorySegment> segments = new ArrayList();
        private final RandomAccessInputView inView;
        private final SimpleCollectingOutputView outView;

        RecordArea() {
            this.outView = new SimpleCollectingOutputView(this.segments, BytesHashMap.this.memoryPool, BytesHashMap.this.segmentSize);
            this.inView = new RandomAccessInputView(this.segments, BytesHashMap.this.segmentSize);
        }

        @Override
        public void release() {
            BytesHashMap.this.returnSegments(this.segments);
            this.segments.clear();
        }

        @Override
        public void reset() {
            this.release();
            this.outView.reset();
            this.inView.setReadPosition(0L);
        }

        @Override
        public int appendRecord(BytesMap.LookupInfo<K, BinaryRow> lookupInfo, BinaryRow value) throws IOException {
            long oldLastPosition = this.outView.getCurrentOffset();
            int skip = BytesHashMap.this.keySerializer.serializeToPages(lookupInfo.getKey(), this.outView);
            long offset = oldLastPosition + (long)skip;
            BytesHashMap.this.valueSerializer.serializeToPages(value, (AbstractPagedOutputView)this.outView);
            if (offset > Integer.MAX_VALUE) {
                LOG.warn("We can't handle key area with more than Integer.MAX_VALUE bytes, because the pointer is a integer.");
                throw new EOFException();
            }
            return (int)offset;
        }

        @Override
        public long getSegmentsSize() {
            return (long)this.segments.size() * (long)BytesHashMap.this.segmentSize;
        }

        @Override
        public void setReadPosition(int position) {
            this.inView.setReadPosition(position);
        }

        @Override
        public boolean readKeyAndEquals(K lookupKey) throws IOException {
            BytesHashMap.this.reusedKey = BytesHashMap.this.keySerializer.mapFromPages(BytesHashMap.this.reusedKey, this.inView);
            return lookupKey.equals(BytesHashMap.this.reusedKey);
        }

        void skipKey() throws IOException {
            BytesHashMap.this.keySerializer.skipRecordFromPages(this.inView);
        }

        @Override
        public BinaryRow readValue(BinaryRow reuse) throws IOException {
            return BytesHashMap.this.valueSerializer.mapFromPages(reuse, (AbstractPagedInputView)this.inView);
        }

        private KeyValueIterator<K, BinaryRow> entryIterator(boolean requiresCopy) {
            return new EntryIterator(requiresCopy);
        }

        private final class EntryIterator
        extends AbstractPagedInputView
        implements KeyValueIterator<K, BinaryRow> {
            private int count;
            private int currentSegmentIndex;
            private final boolean requiresCopy;

            private EntryIterator(boolean requiresCopy) {
                super(RecordArea.this.segments.get(0), BytesHashMap.this.segmentSize);
                this.count = 0;
                this.currentSegmentIndex = 0;
                BytesHashMap.this.destructiveIterator = this;
                this.requiresCopy = requiresCopy;
            }

            @Override
            public boolean advanceNext() throws IOException {
                if (this.count < BytesHashMap.this.numElements) {
                    ++this.count;
                    BytesHashMap.this.keySerializer.mapFromPages(BytesHashMap.this.reusedKey, this);
                    BytesHashMap.this.valueSerializer.mapFromPages((BinaryRow)BytesHashMap.this.reusedValue, (AbstractPagedInputView)this);
                    return true;
                }
                return false;
            }

            @Override
            public K getKey() {
                return this.requiresCopy ? BytesHashMap.this.keySerializer.copy(BytesHashMap.this.reusedKey) : BytesHashMap.this.reusedKey;
            }

            @Override
            public BinaryRow getValue() {
                return this.requiresCopy ? ((BinaryRow)BytesHashMap.this.reusedValue).copy() : (BinaryRow)BytesHashMap.this.reusedValue;
            }

            public boolean hasNext() {
                return this.count < BytesHashMap.this.numElements;
            }

            @Override
            protected int getLimitForSegment(MemorySegment segment) {
                return BytesHashMap.this.segmentSize;
            }

            @Override
            protected MemorySegment nextSegment(MemorySegment current) {
                return RecordArea.this.segments.get(++this.currentSegmentIndex);
            }
        }
    }
}

