/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.function;

import java.util.List;
import java.util.Objects;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileFunctionDefinition.class, name="file"), @JsonSubTypes.Type(value=SQLFunctionDefinition.class, name="sql"), @JsonSubTypes.Type(value=LambdaFunctionDefinition.class, name="lambda")})
public interface FunctionDefinition {
    public static FunctionDefinition file(List<FunctionFileResource> fileResources, String language, String className, String functionName) {
        return new FileFunctionDefinition(fileResources, language, className, functionName);
    }

    public static FunctionDefinition sql(String definition) {
        return new SQLFunctionDefinition(definition);
    }

    public static FunctionDefinition lambda(String definition, String language) {
        return new LambdaFunctionDefinition(definition, language);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FunctionFileResource {
        private static final String FIELD_RESOURCE_TYPE = "resourceType";
        private static final String FIELD_URI = "uri";
        private final String resourceType;
        private final String uri;

        public FunctionFileResource(@JsonProperty(value="resourceType") String resourceType, @JsonProperty(value="uri") String uri) {
            this.resourceType = resourceType;
            this.uri = uri;
        }

        @JsonGetter(value="resourceType")
        public String resourceType() {
            return this.resourceType;
        }

        @JsonGetter(value="uri")
        public String uri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionFileResource that = (FunctionFileResource)o;
            return this.resourceType.equals(that.resourceType) && this.uri.equals(that.uri);
        }

        public int hashCode() {
            return Objects.hash(this.resourceType, this.uri);
        }
    }

    public static class Types {
        public static final String FIELD_TYPE = "type";
        public static final String FILE_TYPE = "file";
        public static final String SQL_TYPE = "sql";
        public static final String LAMBDA_TYPE = "lambda";

        private Types() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class LambdaFunctionDefinition
    implements FunctionDefinition {
        private static final String FIELD_DEFINITION = "definition";
        private static final String FIELD_LANGUAGE = "language";
        private final String definition;
        private final String language;

        public LambdaFunctionDefinition(@JsonProperty(value="definition") String definition, @JsonProperty(value="language") String language) {
            this.definition = definition;
            this.language = language;
        }

        @JsonGetter(value="definition")
        public String definition() {
            return this.definition;
        }

        @JsonGetter(value="language")
        public String language() {
            return this.language;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LambdaFunctionDefinition that = (LambdaFunctionDefinition)o;
            return this.definition.equals(that.definition) && this.language.equals(that.language);
        }

        public int hashCode() {
            return Objects.hash(this.definition, this.language);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class SQLFunctionDefinition
    implements FunctionDefinition {
        private static final String FIELD_DEFINITION = "definition";
        private final String definition;

        public SQLFunctionDefinition(@JsonProperty(value="definition") String definition) {
            this.definition = definition;
        }

        @JsonGetter(value="definition")
        public String definition() {
            return this.definition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SQLFunctionDefinition that = (SQLFunctionDefinition)o;
            return Objects.equals(this.definition, that.definition);
        }

        public int hashCode() {
            return Objects.hash(this.definition);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class FileFunctionDefinition
    implements FunctionDefinition {
        private static final String FIELD_FILE_RESOURCES = "fileResources";
        private static final String FIELD_LANGUAGE = "language";
        private static final String FIELD_CLASS_NAME = "className";
        private static final String FIELD_FUNCTION_NAME = "functionName";
        @JsonProperty(value="fileResources")
        private final List<FunctionFileResource> fileResources;
        @JsonProperty(value="language")
        private String language;
        @JsonProperty(value="className")
        private String className;
        @JsonProperty(value="functionName")
        private String functionName;

        public FileFunctionDefinition(@JsonProperty(value="fileResources") List<FunctionFileResource> fileResources, @JsonProperty(value="language") String language, @JsonProperty(value="className") String className, @JsonProperty(value="functionName") String functionName) {
            this.fileResources = fileResources;
            this.language = language;
            this.className = className;
            this.functionName = functionName;
        }

        @JsonGetter(value="fileResources")
        public List<FunctionFileResource> fileResources() {
            return this.fileResources;
        }

        @JsonGetter(value="language")
        public String language() {
            return this.language;
        }

        @JsonGetter(value="className")
        public String className() {
            return this.className;
        }

        @JsonGetter(value="functionName")
        public String functionName() {
            return this.functionName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileFunctionDefinition that = (FileFunctionDefinition)o;
            return Objects.equals(this.fileResources, that.fileResources) && Objects.equals(this.language, that.language) && Objects.equals(this.className, that.className) && Objects.equals(this.functionName, that.functionName);
        }

        public int hashCode() {
            int result = Objects.hash(this.language, this.className, this.functionName);
            result = 31 * result + Objects.hashCode(this.fileResources);
            return result;
        }
    }
}

