/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.utils.StringUtils;

@Public
public class Path
implements Comparable<Path>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Pattern HAS_DRIVE_LETTER_SPECIFIER = Pattern.compile("^/?[a-zA-Z]:");
    private static final Pattern SLASHES = Pattern.compile("/+");
    private URI uri;

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        String parentPath = parentUri.getPath();
        if (!parentPath.equals(SEPARATOR) && !parentPath.isEmpty()) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, parentUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        URI resolved = parentUri.resolve(child.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), resolved.getPath(), resolved.getFragment());
    }

    private void checkPathArg(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
    }

    public Path(String pathString) {
        this.checkPathArg((String)pathString);
        if (Path.hasWindowsDrive((String)pathString) && ((String)pathString).charAt(0) != '/') {
            pathString = SEPARATOR + (String)pathString;
        }
        String scheme = null;
        String authority = null;
        int start = 0;
        int colon2 = ((String)pathString).indexOf(58);
        int slash = ((String)pathString).indexOf(47);
        if (colon2 != -1 && (slash == -1 || colon2 < slash)) {
            scheme = ((String)pathString).substring(0, colon2);
            start = colon2 + 1;
        }
        if (((String)pathString).startsWith("//", start) && ((String)pathString).length() - start > 2) {
            int nextSlash = ((String)pathString).indexOf(47, start + 2);
            int authEnd = nextSlash > 0 ? nextSlash : ((String)pathString).length();
            authority = ((String)pathString).substring(start + 2, authEnd);
            start = authEnd;
        }
        String path = ((String)pathString).substring(start);
        this.initialize(scheme, authority, path, null);
    }

    public Path(URI aUri) {
        this.uri = aUri.normalize();
    }

    public Path(String scheme, String authority, String path) {
        this.checkPathArg((String)path);
        if (Path.hasWindowsDrive((String)path) && ((String)path).charAt(0) != '/') {
            path = SEPARATOR + (String)path;
        }
        if (!WINDOWS && ((String)path).charAt(0) != '/') {
            path = "./" + (String)path;
        }
        this.initialize(scheme, authority, (String)path, null);
    }

    private void initialize(String scheme, String authority, String path, String fragment) {
        try {
            this.uri = new URI(scheme, authority, Path.normalizePath(scheme, path), null, fragment).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String normalizePath(String scheme, String path) {
        path = SLASHES.matcher(path).replaceAll(SEPARATOR);
        if (WINDOWS && (Path.hasWindowsDrive(path) || scheme == null || scheme.isEmpty() || scheme.equals("file"))) {
            path = StringUtils.replace(path, "\\", SEPARATOR);
        }
        int minLength = Path.startPositionWithoutWindowsDrive(path) + 1;
        if (path.length() > minLength && path.endsWith(SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean hasWindowsDrive(String path) {
        return WINDOWS && HAS_DRIVE_LETTER_SPECIFIER.matcher(path).find();
    }

    private static int startPositionWithoutWindowsDrive(String path) {
        if (Path.hasWindowsDrive(path)) {
            return path.charAt(0) == '/' ? 3 : 2;
        }
        return 0;
    }

    public URI toUri() {
        return this.uri;
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public Path createTempPath() {
        return new Path(this.getParent(), String.format(".%s.%s.tmp", this.getName(), UUID.randomUUID()));
    }

    public Path getParent() {
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int start = Path.startPositionWithoutWindowsDrive(path);
        if (path.length() == start || lastSlash == start && path.length() == start + 1) {
            return null;
        }
        String parent = lastSlash == -1 ? CUR_DIR : path.substring(0, lastSlash == start ? start + 1 : lastSlash);
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme()).append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//").append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && Path.hasWindowsDrive(path) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        if (this.uri.getFragment() != null) {
            buffer.append("#").append(this.uri.getFragment());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int compareTo(Path that) {
        return this.uri.compareTo(that.uri);
    }
}

